/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Number;;
import fr.apteryx.imageio.dicom.Attribute;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.Day;
import fr.apteryx.imageio.dicom.DicomColorSpace;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.Modality;
import fr.apteryx.imageio.dicom.PixelData;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.Time;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.VOILUTColorModel;
import fr.apteryx.imageio.dicom.VOIWindowColorModel;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DicomMetadata
extends IIOMetadata
implements Serializable {
    final DicomObject obj;

    DicomMetadata(DataSet dataSet, String string, String string2, TransferSyntax transferSyntax) {
        this(new DicomObject(dataSet, string, string2, transferSyntax));
    }

    public DicomMetadata() {
        this(new DataSet(), null, null, null);
    }

    DicomMetadata(DicomObject dicomObject) {
        this.obj = dicomObject;
        this.nativeMetadataFormatClassName = "DicomMetadataFormat";
        this.nativeMetadataFormatName = "fr_apteryx_imageio_dicom_1.0";
        this.standardFormatSupported = true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.nativeMetadataFormatName);
        Iterator iterator = this.obj.ds.values().iterator();
        while (iterator.hasNext()) {
            DataElement dataElement = (DataElement)iterator.next();
            Attribute attribute = dataElement.getAttribute();
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(attribute == null ? Tag.toString(dataElement.tag) : attribute.name);
            iIOMetadataNode2.setUserObject(dataElement);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private Node getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!string.equalsIgnoreCase(nodeList.item(i).getNodeName())) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private String getAttr(Node node, String string) {
        return node.getAttributes().getNamedItem(string).getNodeValue();
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals("javax_imageio_1.0")) {
            Object object;
            Object object2;
            Node node2 = this.getChild(node, "Chroma");
            if (node2 != null) {
                int n;
                object2 = this.getChild(node2, "BlackIsZero");
                if (object2 != null && "false".equalsIgnoreCase(this.getAttr((Node)object2, "value"))) {
                    this.obj.ds.add(2621444, "MONOCHROME1");
                }
                if ((object2 = this.getChild(node2, "Palette")) != null && (n = (object = object2.getChildNodes()).getLength()) > 0) {
                    int n2;
                    int n3;
                    short[] sArray = new short[n];
                    short[] sArray2 = new short[n];
                    short[] sArray3 = new short[n];
                    int n4 = Integer.MAX_VALUE;
                    for (n3 = 0; n3 < n; ++n3) {
                        n2 = Integer.parseInt(((IIOMetadataNode)object.item(n3)).getAttribute("index"));
                        if (n2 >= n4) continue;
                        n4 = n2;
                    }
                    n3 = 1;
                    try {
                        for (n2 = 0; n2 < n; ++n2) {
                            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)object.item(n2);
                            int n5 = Integer.parseInt(iIOMetadataNode.getAttribute("index"));
                            sArray[n5 - n4] = (short)Integer.parseInt(iIOMetadataNode.getAttribute("red"));
                            sArray2[n5 - n4] = (short)Integer.parseInt(iIOMetadataNode.getAttribute("green"));
                            sArray3[n5 - n4] = (short)Integer.parseInt(iIOMetadataNode.getAttribute("blue"));
                            if (n3 == 0 || sArray[n5 - n4] <= 255 && sArray2[n5 - n4] <= 255 && sArray3[n5 - n4] <= 255) continue;
                            n3 = 0;
                        }
                    }
                    catch (Exception exception) {
                        throw new IIOInvalidTreeException("Invalid specification", (Node)object2);
                    }
                    short[] sArray4 = new short[]{(short)n, (short)n4, n3 != 0 ? (short)8 : 16};
                    this.obj.ds.add(2625793, sArray4);
                    this.obj.ds.add(2625794, sArray4);
                    this.obj.ds.add(2625795, sArray4);
                    this.obj.ds.add(2626049, sArray);
                    this.obj.ds.add(2626050, sArray2);
                    this.obj.ds.add(2626051, sArray3);
                }
            }
            if ((node2 = this.getChild(node, "Dimension")) != null) {
                try {
                    object2 = Float.valueOf(this.getAttr(this.getChild(node2, "HorizontalPhysicalPixelSpacing"), "value"));
                    object = Float.valueOf(this.getAttr(this.getChild(node2, "VerticalPhysicalPixelSpacing"), "value"));
                    this.obj.ds.add(2621488, new Float[]{object, object2});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((node2 = this.getChild(node, "Document")) != null) {
                object2 = this.getChild(node2, "ImageCreationTime");
                if (object2 != null) {
                    object = this.standardToDate((Node)object2);
                    this.obj.ds.add(524323, new Day((Date)object));
                    this.obj.ds.add(524339, new Time((Date)object));
                }
                if ((object2 = this.getChild(node2, "ImageModificationTime")) != null) {
                    object = this.standardToDate((Node)object2);
                    this.obj.ds.add(1576978, new Day((Date)object));
                    this.obj.ds.add(1576980, new Time((Date)object));
                }
            }
        } else if (string.equals(this.nativeMetadataFormatName)) {
            NodeList nodeList = node.getChildNodes();
            DataSet dataSet = this.obj.ds;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList.item(i);
                DataElement dataElement = (DataElement)iIOMetadataNode.getUserObject();
                dataSet.add(dataElement);
            }
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + string);
        }
    }

    public void reset() {
        this.obj.reset();
    }

    public String toString() {
        return this.obj.toString();
    }

    private void addNode(IIOMetadataNode iIOMetadataNode, String string, String string2, String string3) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        iIOMetadataNode2.setAttribute(string2, string3);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
    }

    protected IIOMetadataNode getStandardChromaNode() {
        DataSet dataSet = this.obj.ds;
        String string = dataSet.findString(2621444);
        if (string == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        String string2 = DicomColorSpace.tagToIIOStandard(string);
        if (string2 != null) {
            this.addNode(iIOMetadataNode, "ColorSpaceType", "name", string2);
        }
        if ((string2 = dataSet.findString(0x280002)) != null) {
            this.addNode(iIOMetadataNode, "NumChannels", "value", string2);
        }
        this.addNode(iIOMetadataNode, "BlackIsZero", "value", string.equals("MONOCHROME1") ? "FALSE" : "TRUE");
        if ("PALETTE COLOR".equals(string)) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            Number[] numberArray = (Number[])dataSet.findValue(2625793, Number;.class);
            Number[] numberArray2 = (Number[])dataSet.findValue(2625794, Number;.class);
            Number[] numberArray3 = (Number[])dataSet.findValue(2625795, Number;.class);
            short[] sArray = (short[])dataSet.findValue(2626049, [S.class);
            short[] sArray2 = (short[])dataSet.findValue(2626050, [S.class);
            short[] sArray3 = (short[])dataSet.findValue(2626051, [S.class);
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = numberArray[1].intValue();
            int n4 = numberArray[0].intValue();
            if (n4 == 0) {
                n4 = 65536;
            }
            int n5 = numberArray2[1].intValue();
            int n6 = numberArray2[0].intValue();
            if (n6 == 0) {
                n6 = 65536;
            }
            int n7 = numberArray3[1].intValue();
            int n8 = numberArray3[0].intValue();
            if (n8 == 0) {
                n8 = 65536;
            }
            if (n3 < n) {
                n = n3;
            }
            if (n5 < n) {
                n = n5;
            }
            if (n7 < n) {
                n = n7;
            }
            if (n3 + n4 > n2) {
                n2 = n3 + n4;
            }
            if (n5 + n6 > n2) {
                n2 = n5 + n6;
            }
            if (n7 + n8 > n2) {
                n2 = n7 + n8;
            }
            for (int i = n; i < n2; ++i) {
                int n9;
                int n10;
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                iIOMetadataNode3.setAttribute("index", Integer.toString(i));
                int n11 = i - n3;
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n11 >= n4) {
                    n11 = n4;
                }
                if ((n10 = i - n5) < 0) {
                    n10 = 0;
                }
                if (n10 >= n6) {
                    n10 = n6;
                }
                if ((n9 = i - n7) < 0) {
                    n9 = 0;
                }
                if (n9 >= n8) {
                    n9 = n8;
                }
                iIOMetadataNode3.setAttribute("red", Integer.toString(sArray[n11] & 0xFFFF));
                iIOMetadataNode3.setAttribute("green", Integer.toString(sArray2[n10] & 0xFFFF));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(sArray3[n9] & 0xFFFF));
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        PixelData pixelData = (PixelData)this.obj.ds.findValue(2145386512, PixelData.class);
        if (pixelData == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = null;
        TransferSyntax transferSyntax = pixelData.TS;
        if (transferSyntax == TransferSyntax.RLE_COMPRESSION) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "RLE");
            this.addNode(iIOMetadataNode, "Lossless", "value", "TRUE");
        } else if (transferSyntax == TransferSyntax.JPEG_BASELINE_1 || transferSyntax == TransferSyntax.JPEG_EXTENDED_2_4 || transferSyntax == TransferSyntax.JPEG_PROGRESSIVE_10_12) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG");
            this.addNode(iIOMetadataNode, "Lossless", "value", "FALSE");
        } else if (transferSyntax == TransferSyntax.JPEG_LOSSLESS_14 || transferSyntax == TransferSyntax.JPEG_LOSSLESS_15 || transferSyntax == TransferSyntax.JPEG_LOSSLESS_14SV1) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG-LOSSLESS");
            this.addNode(iIOMetadataNode, "Lossless", "value", "TRUE");
        } else if (transferSyntax == TransferSyntax.JPEG_LS_LOSSLESS) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG-LS");
            this.addNode(iIOMetadataNode, "Lossless", "value", "TRUE");
        } else if (transferSyntax == TransferSyntax.JPEG_LS_NEAR_LOSSLESS) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG-LS");
            this.addNode(iIOMetadataNode, "Lossless", "value", "FALSE");
        } else if (transferSyntax == TransferSyntax.JPEG2000_LOSSLESS) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG2000");
            this.addNode(iIOMetadataNode, "Lossless", "value", "TRUE");
        } else if (transferSyntax == TransferSyntax.JPEG2000) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "JPEG2000");
            this.addNode(iIOMetadataNode, "Lossless", "value", "FALSE");
        } else if (transferSyntax == TransferSyntax.DEFLATED_EXPLICIT_LITTLEENDIAN) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            this.addNode(iIOMetadataNode, "CompressionTypeName", "value", "DEFLATE");
            this.addNode(iIOMetadataNode, "Lossless", "value", "TRUE");
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        Object object;
        DataSet dataSet = this.obj.ds;
        int n = dataSet.findInt(0x280002);
        if (n <= 0) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        if (n > 1) {
            PixelData pixelData = (PixelData)dataSet.findValue(2145386512, PixelData.class);
            if (pixelData == null) {
                return null;
            }
            object = pixelData.TS;
            int n2 = dataSet.findInt(2621446);
            this.addNode(iIOMetadataNode, "PlanarConfiguration", "value", object == TransferSyntax.RLE_COMPRESSION || ((TransferSyntax)object).uid.startsWith("1.2.840.10008.1.2.4.") || n2 == 0 ? "PixelInterleaved" : "PlaneInterleaved");
        }
        int n3 = dataSet.findInt(2621699);
        object = dataSet.findString(2621444);
        this.addNode(iIOMetadataNode, "SampleFormat", "value", "PALETTE COLOR".equals(object) ? "Index" : (n3 == 0 ? "UnsignedIntegral" : "SignedIntegral"));
        this.addNode(iIOMetadataNode, "BitsPerSample", "value", dataSet.findString(2621696));
        this.addNode(iIOMetadataNode, "SignificantBitsPerSample", "value", dataSet.findString(2621697));
        this.addNode(iIOMetadataNode, "SampleMSB", "value", dataSet.findString(2621698));
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        Integer[] integerArray;
        DataSet dataSet = this.obj.ds;
        String string = dataSet.findString(2621456);
        if (string == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        Float[] floatArray = (Float[])dataSet.findValue(2621488, Float;.class);
        if (floatArray == null && (floatArray = (Float[])dataSet.findValue(1577316, Float;.class)) == null && (floatArray = (Float[])dataSet.findValue(1581072, Float;.class)) == null) {
            dataSet.findValue(805437457, Float;.class);
        }
        if ((integerArray = (Integer[])dataSet.findValue(2621492, Integer;.class)) != null) {
            this.addNode(iIOMetadataNode, "PixelAspectRatio", "value", Double.toString(integerArray[1].doubleValue() / (double)integerArray[0].intValue()));
        } else if (floatArray != null) {
            this.addNode(iIOMetadataNode, "PixelAspectRatio", "value", Double.toString(floatArray[1].doubleValue() / (double)floatArray[0].floatValue()));
        }
        if (floatArray != null) {
            this.addNode(iIOMetadataNode, "HorizontalPhysicalPixelSpacing", "value", floatArray[1].toString());
            this.addNode(iIOMetadataNode, "VerticalPhysicalPixelSpacing", "value", floatArray[0].toString());
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode;
        DataSet dataSet = this.obj.ds;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Document");
        Integer n = (Integer)dataSet.findValue(2621449, Integer.class);
        if (n != null) {
            switch (n) {
                case 1577059: 
                case 1577061: 
                case 5505136: 
                case 5505280: {
                    this.addNode(iIOMetadataNode2, "SubimageInterpretation", "value", "AnimationFrame");
                    break;
                }
                case 5505152: {
                    this.addNode(iIOMetadataNode2, "SubimageInterpretation", "value", "VolumeSlice");
                    break;
                }
                case 5505056: 
                case 0x540050: 
                case 5505168: {
                    this.addNode(iIOMetadataNode2, "SubimageInterpretation", "value", "ObjectView");
                    break;
                }
                case 5505040: {
                    this.addNode(iIOMetadataNode2, "SubimageInterpretation", "value", "SpectralSlice");
                }
            }
        }
        Date date = (Date)dataSet.findValue(524323, Date.class);
        Date date2 = null;
        if (date != null) {
            date2 = (Date)dataSet.findValue(524339, Date.class);
        } else {
            date = (Date)dataSet.findValue(524322, Date.class);
            if (date != null) {
                date2 = (Date)dataSet.findValue(524338, Date.class);
            } else {
                date = (Date)dataSet.findValue(524321, Date.class);
                if (date != null) {
                    date2 = (Date)dataSet.findValue(524337, Date.class);
                } else {
                    date = (Date)dataSet.findValue(524320, Date.class);
                    if (date != null) {
                        date2 = (Date)dataSet.findValue(524336, Date.class);
                    }
                }
            }
        }
        if (date != null) {
            iIOMetadataNode = new IIOMetadataNode("ImageCreationTime");
            this.dateToStandard(iIOMetadataNode, date, date2);
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        if ((date = (Date)dataSet.findValue(1576978, Date.class)) != null) {
            date2 = (Date)dataSet.findValue(1576980, Date.class);
            iIOMetadataNode = new IIOMetadataNode("ImageModificationTime");
            this.dateToStandard(iIOMetadataNode, date, date2);
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        return iIOMetadataNode2;
    }

    private void dateToStandard(IIOMetadataNode iIOMetadataNode, Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        iIOMetadataNode.setAttribute("year", Integer.toString(calendar.get(1)));
        iIOMetadataNode.setAttribute("month", Integer.toString(calendar.get(2) + 1));
        iIOMetadataNode.setAttribute("day", Integer.toString(calendar.get(5)));
        if (date2 != null) {
            calendar.setTime(date2);
            iIOMetadataNode.setAttribute("hour", Integer.toString(calendar.get(11)));
            iIOMetadataNode.setAttribute("minute", Integer.toString(calendar.get(12)));
            iIOMetadataNode.setAttribute("second", Integer.toString(calendar.get(13)));
        }
    }

    private Date standardToDate(Node node) throws IIOInvalidTreeException {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.set(1, Integer.parseInt(this.getAttr(node, "year")));
            calendar.set(2, Integer.parseInt(this.getAttr(node, "month")) - 1);
            calendar.set(5, Integer.parseInt(this.getAttr(node, "month")) - 1);
        }
        catch (Exception exception) {
            throw new IIOInvalidTreeException("Bad format", node);
        }
        try {
            calendar.set(10, Integer.parseInt(this.getAttr(node, "hour")));
        }
        catch (Exception exception) {
            calendar.set(10, 0);
        }
        try {
            calendar.set(12, Integer.parseInt(this.getAttr(node, "minute")));
        }
        catch (Exception exception) {
            calendar.set(12, 0);
        }
        try {
            calendar.set(13, Integer.parseInt(this.getAttr(node, "second")));
        }
        catch (Exception exception) {
            calendar.set(13, 0);
        }
        return calendar.getTime();
    }

    void updateFromImage(int n, int n2, SampleModel sampleModel, ColorModel colorModel) throws DicomException {
        DataSet dataSet = this.obj.ds;
        dataSet.add(2621456, n2);
        dataSet.add(2621457, n);
        int n3 = sampleModel.getSampleSize(0);
        if (colorModel != null && colorModel.getComponentSize(0) < n3) {
            n3 = colorModel.getComponentSize(0);
        }
        switch (sampleModel.getDataType()) {
            case 0: {
                dataSet.add(2621696, 8);
                dataSet.add(2621697, n3);
                dataSet.add(2621698, n3 - 1);
                dataSet.add(2621699, 0);
                boolean bl = false;
                int n4 = (1 << n3) - 1;
                break;
            }
            case 1: {
                dataSet.add(2621696, 16);
                dataSet.add(2621697, n3);
                dataSet.add(2621698, n3 - 1);
                dataSet.add(2621699, 0);
                boolean bl = false;
                int n5 = (1 << n3) - 1;
                break;
            }
            case 2: {
                dataSet.add(2621696, 16);
                dataSet.add(2621697, n3);
                dataSet.add(2621698, n3 - 1);
                dataSet.add(2621699, 1);
                int n6 = (1 << n3 - 1) - 1;
                int n7 = -n6 - 1;
                break;
            }
            default: {
                throw new DicomException("Unsupported", "DataType");
            }
        }
        String string = dataSet.findString(2621444);
        switch (sampleModel.getNumBands()) {
            case 1: {
                String string2;
                dataSet.add(0x280002, 1);
                if (string != null && (string.equals("MONOCHROME1") || string.equals("MONOCHROME2") || string.equals("PALETTE COLOR")) && colorModel == null) break;
                if (colorModel == null) {
                    string2 = "MONOCHROME2";
                } else if (colorModel instanceof IndexColorModel) {
                    this.obj.updateFromICM((IndexColorModel)colorModel);
                    string2 = "PALETTE COLOR";
                } else {
                    ColorSpace colorSpace = colorModel.getColorSpace();
                    float[] fArray = colorSpace.toRGB(new float[]{0.0f});
                    float f = fArray[0] + fArray[1] + fArray[2];
                    fArray = colorSpace.toRGB(new float[]{1.0f});
                    float f2 = fArray[0] + fArray[1] + fArray[2];
                    String string3 = string2 = f <= f2 ? "MONOCHROME2" : "MONOCHROME1";
                    if (colorModel instanceof VOIWindowColorModel) {
                        dataSet.add(2625616, ((VOIWindowColorModel)colorModel).getCenter());
                        dataSet.add(2625617, ((VOIWindowColorModel)colorModel).getWidth());
                    } else if (colorModel instanceof VOILUTColorModel) {
                        DataSet dataSet2 = new DataSet();
                        Object object = ((VOILUTColorModel)colorModel).getLUT();
                        int n8 = ((VOILUTColorModel)colorModel).getFirst();
                        dataSet2.add(2633730, new int[]{Array.getLength(object), n8, object instanceof short[] ? 16 : 8});
                        dataSet2.add(2633734, object);
                        dataSet.add(2633744, dataSet2);
                    }
                }
                dataSet.add(2621444, string2);
                break;
            }
            case 3: {
                dataSet.add(0x280002, 3);
                dataSet.add(2621446, 1);
                if (string != null && colorModel == null && (string.equals("YBR_FULL") || string.equals("YBR_FULL_422") || string.equals("YBR_PARTIAL_422") || string.equals("YBR_PARTIAL_420") || string.equals("YBR_ICT") || string.equals("YBR_RCT") || string.equals("RGB") || string.equals("HSV"))) break;
                dataSet.add(2621444, colorModel == null ? "RGB" : DicomColorSpace.getDicomType(colorModel.getColorSpace()));
                break;
            }
            case 4: {
                dataSet.add(0x280002, 4);
                dataSet.add(2621446, 1);
                if (string != null && colorModel == null && (string.equals("CMYK") || string.equals("ARGB"))) break;
                dataSet.add(2621444, colorModel == null ? "CMYK" : DicomColorSpace.getDicomType(colorModel.getColorSpace()));
            }
        }
    }

    void normalize(DicomWarningListener dicomWarningListener) throws DicomException {
        this.obj.normalize(dicomWarningListener);
    }

    public void setAttribute(int n, Object object) {
        this.obj.ds.add(n, object);
    }

    public void setAttribute(int n, int n2) {
        this.obj.ds.add(n, n2);
    }

    public void setAttribute(int n, long l) {
        this.obj.ds.add(n, l);
    }

    public void setModality(String string) throws DicomException {
        if (!Modality.mod2sop.containsKey(string) && !"OT".equals(string)) {
            throw new DicomException("Unsupported", "Unknown modality " + string);
        }
        this.obj.ds.add(524384, string);
    }

    public Object getAttribute(int n) {
        return this.obj.ds.findValue(n, Object.class);
    }

    public String getAttributeString(int n) {
        return this.obj.ds.findString(n);
    }

    public int getAttributeInt(int n) {
        return this.obj.ds.findInt(n);
    }

    public long getAttributeLong(int n) {
        return this.obj.ds.findLong(n);
    }

    public DataSet getAttributes() {
        return this.obj.ds;
    }

    public boolean hasAttribute(int n) {
        return this.obj.ds.has(n);
    }

    public void removeAttribute(int n) {
        this.obj.ds.remove(n);
    }

    public void setSOPClass(String string) {
        this.obj.sopClass = string;
    }

    public String getSOPClass() {
        return this.obj.sopClass;
    }

    public void setSOPInstance(String string) {
        this.obj.sopInstance = string;
    }

    public String getSOPInstance() {
        return this.obj.sopInstance;
    }

    public BufferedImage applyGrayscaleTransformations(BufferedImage bufferedImage, int n) {
        DicomObject.ApplyLUTTarget applyLUTTarget = new DicomObject.ApplyLUTTarget(bufferedImage);
        this.obj.applyLUT(applyLUTTarget, n, null);
        return applyLUTTarget.bi;
    }

    public void removeUnwritableElements() {
        this.obj.ds.removeUnwritableElements();
    }
}

