/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.ByteArrayImageInputStream;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DataSetReader;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.PDU;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.TempFileImageInputStream;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

final class ReceivedMessage {
    private final Association association;
    DataSet command;
    TransferSyntax transferSyntax;
    private byte[] command_buf;
    private File temp_dataset_f;
    private FileOutputStream temp_dataset_os;
    private TempFileImageInputStream fiis;

    ReceivedMessage(Association association) {
        this.association = association;
    }

    boolean add(PDU.DataTf dataTf) throws DicomException {
        int n;
        if (dataTf.len < 6) {
            return false;
        }
        for (int i = 0; i < dataTf.len; i += n + 4) {
            Object object;
            n = (int)PDU.readUnsignedInt(dataTf.buf, i);
            if (n <= 1) continue;
            byte by = dataTf.buf[i + 5];
            if ((by & 1) == 1) {
                Object object2;
                if (this.command_buf == null) {
                    this.command_buf = new byte[n - 2];
                    System.arraycopy(dataTf.buf, i + 6, this.command_buf, 0, n - 2);
                } else {
                    object2 = new byte[this.command_buf.length + n - 2];
                    System.arraycopy(this.command_buf, 0, object2, 0, this.command_buf.length);
                    System.arraycopy(dataTf.buf, i + 6, object2, this.command_buf.length, n - 2);
                    this.command_buf = object2;
                }
                if ((by & 2) != 2) continue;
                object2 = new ByteArrayImageInputStream(this.command_buf);
                object = new DataSetReader((ImageInputStream)object2, null, RawValues.NONE, false);
                try {
                    this.command = ((DataSetReader)object).readDataSet();
                    int n2 = this.command.findInt(2048);
                    if (n2 != 257) continue;
                    return true;
                }
                catch (DicomException dicomException) {
                    throw dicomException;
                }
                catch (IOException iOException) {
                    throw new DicomException("ProtocoleViolation", iOException.getMessage());
                }
            }
            try {
                if (this.temp_dataset_f == null) {
                    this.temp_dataset_f = File.createTempFile("dcm", null);
                    this.temp_dataset_f.deleteOnExit();
                    this.temp_dataset_os = new FileOutputStream(this.temp_dataset_f);
                }
                this.temp_dataset_os.write(dataTf.buf, i + 6, n - 2);
                if ((by & 2) != 2) continue;
                this.temp_dataset_os.close();
                int n3 = dataTf.buf[i + 4] & 0xFF;
                object = (AbstractSyntax)this.association.syn_id_hash.get(new Integer(n3));
                if (object == null || ((AbstractSyntax)object).selected_ts == null) {
                    throw new DicomException("ProtocoleViolation", "Invalid Presentation ID received");
                }
                this.transferSyntax = ((AbstractSyntax)object).selected_ts;
                this.fiis = new TempFileImageInputStream(this.temp_dataset_f);
                return true;
            }
            catch (IOException iOException) {
                try {
                    this.temp_dataset_os.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.temp_dataset_f.delete();
                throw new DicomException("EnvironmentError", "Cannot write temporary file");
            }
        }
        return false;
    }

    DataSet readDataSet(RawValues rawValues, boolean bl, DicomWarningListener dicomWarningListener) throws DicomException {
        if (this.fiis == null) {
            return null;
        }
        try {
            this.fiis.seek(0L);
            DataSetReader dataSetReader = new DataSetReader(this.fiis, this.transferSyntax, dicomWarningListener, rawValues, bl);
            DataSet dataSet = dataSetReader.readDataSet();
            return dataSet;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        catch (IOException iOException) {
            throw new DicomException("EnvironmentError", "Cannot read temporary file");
        }
    }
}

