/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AReleaseRQImpl;
import org.dcm4cheri.net.DimseReaderImpl;
import org.dcm4cheri.net.DimseWriterImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class AssociationImpl
implements Association {
    private final FsmImpl fsm;
    private final DimseReaderImpl reader;
    private final DimseWriterImpl writer;
    private int msgID = 0;
    private final byte[] b10 = new byte[10];
    private Hashtable properties = null;
    private int rqTimeout = 5000;
    private int acTimeout = 5000;
    private int dimseTimeout = 0;

    public AssociationImpl(Socket s, boolean requestor) throws IOException {
        this.fsm = new FsmImpl(this, s, requestor);
        this.reader = new DimseReaderImpl(this.fsm);
        this.writer = new DimseWriterImpl(this.fsm);
    }

    public final boolean isRequestor() {
        return this.fsm.isRequestor();
    }

    public Socket getSocket() {
        return this.fsm.socket();
    }

    public final String toString() {
        return "Assoc[sock=" + this.fsm.socket() + ", state=" + this.getStateAsString() + "]";
    }

    public void addAssociationListener(AssociationListener l) {
        this.fsm.addAssociationListener(l);
    }

    public void removeAssociationListener(AssociationListener l) {
        this.fsm.removeAssociationListener(l);
    }

    public final int getState() {
        return this.fsm.getState();
    }

    public final String getStateAsString() {
        return this.fsm.getStateAsString();
    }

    public final synchronized int nextMsgID() {
        return ++this.msgID;
    }

    public int getMaxOpsInvoked() {
        return this.fsm.getMaxOpsInvoked();
    }

    public int getMaxOpsPerformed() {
        return this.fsm.getMaxOpsPerformed();
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.fsm.getAAssociateRQ();
    }

    public AAssociateAC getAAssociateAC() {
        return this.fsm.getAAssociateAC();
    }

    public AAssociateRJ getAAssociateRJ() {
        return this.fsm.getAAssociateRJ();
    }

    public AAbort getAAbort() {
        return this.fsm.getAAbort();
    }

    public String getCallingAET() {
        return this.fsm.getCallingAET();
    }

    public String getCalledAET() {
        return this.fsm.getCalledAET();
    }

    public void setThreadPool(LF_ThreadPool pool) {
        this.fsm.setThreadPool(pool);
        this.reader.setThreadPool(pool);
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.fsm.setSoCloseDelay(soCloseDelay);
    }

    public final int getSoCloseDelay() {
        return this.fsm.getSoCloseDelay();
    }

    public int getRqTimeout() {
        return this.rqTimeout;
    }

    public void setRqTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.rqTimeout = timeout;
    }

    public int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public void setDimseTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.dimseTimeout = timeout;
    }

    public int getAcTimeout() {
        return this.acTimeout;
    }

    public void setAcTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.acTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU connect(AAssociateRQ rq) throws IOException {
        this.fsm.initMDC(rq);
        try {
            this.fsm.write(rq);
            PDU pDU = this.fsm.read(this.acTimeout, this.b10);
            return pDU;
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU accept(AcceptorPolicy policy) throws IOException {
        this.initMDC();
        try {
            PDU rq = this.fsm.read(this.rqTimeout, this.b10);
            if (!(rq instanceof AAssociateRQ)) {
                AAbort aAbort = (AAbort)rq;
                return aAbort;
            }
            PDU rp = policy.negotiate(this);
            if (rp instanceof AAssociateAC) {
                this.fsm.write((AAssociateAC)rp);
            } else {
                this.fsm.write((AAssociateRJ)rp);
            }
            PDU pDU = rp;
            return pDU;
        }
        finally {
            this.clearMDC();
        }
    }

    final void initMDC() {
        this.fsm.initMDC();
    }

    final void clearMDC() {
        this.fsm.clearMDC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Dimse read() throws IOException {
        this.initMDC();
        try {
            Dimse dimse = this.reader.read(this.dimseTimeout);
            if (dimse != null) {
                this.msgID = Math.max(dimse.getCommand().getMessageID(), this.msgID);
            }
            Dimse dimse2 = dimse;
            return dimse2;
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Dimse dimse) throws IOException {
        this.initMDC();
        try {
            this.msgID = Math.max(dimse.getCommand().getMessageID(), this.msgID);
            this.writer.write(dimse);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU release(int timeout) throws IOException {
        this.initMDC();
        try {
            this.fsm.write(AReleaseRQImpl.getInstance());
            PDU pDU = this.fsm.read(timeout, this.b10);
            return pDU;
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeReleaseRQ() throws IOException {
        this.initMDC();
        try {
            this.fsm.write(AReleaseRQImpl.getInstance());
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort(AAbort aa) throws IOException {
        this.initMDC();
        try {
            this.fsm.write(aa);
        }
        finally {
            this.clearMDC();
        }
    }

    public final String getAcceptedTransferSyntaxUID(int pcid) {
        return this.fsm.getAcceptedTransferSyntaxUID(pcid);
    }

    public final PresContext getProposedPresContext(int pcid) {
        return this.fsm.getProposedPresContext(pcid);
    }

    public final PresContext getAcceptedPresContext(String asuid, String tsuid) {
        return this.fsm.getAcceptedPresContext(asuid, tsuid);
    }

    public final List listAcceptedPresContext(String asuid) {
        return this.fsm.listAcceptedPresContext(asuid);
    }

    public final int countAcceptedPresContext() {
        return this.fsm.countAcceptedPresContext();
    }

    public Object getProperty(Object key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable(2);
        }
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public boolean isPackPDVs() {
        return this.writer.isPackPDVs();
    }

    public void setPackPDVs(boolean packPDVs) {
        this.writer.setPackPDVs(packPDVs);
    }
}

