/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TextContent;
import org.dcm4cheri.srom.NamedContentImpl;

class TextContentImpl
extends NamedContentImpl
implements TextContent {
    private static final int TEXT_PROMPT_LEN = 20;
    private String text;

    TextContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, String text) {
        super(owner, obsDateTime, template, TextContentImpl.checkNotNull(name));
        this.setText(text);
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new TextContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.text);
    }

    public final void setName(Code newName) {
        this.name = TextContentImpl.checkNotNull(newName);
    }

    public String toString() {
        StringBuffer sb = this.prompt().append('\"');
        if (this.text.length() <= 20) {
            sb.append(this.text);
        } else {
            sb.append(this.text.substring(0, 20)).append("..");
        }
        return sb.append('\"').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TEXT;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        if (text.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.text = text;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putUT(4235616, this.text);
    }
}

