/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.project.GlobalVariablesImplement;
import open.dolphin.utils.CombinedStringParser;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class DirectionDialog
extends JDialog {
    private DocumentModel documentModel;
    private DirectionTableModel tableModel;
    private String[] directionsList = new String[8];
    private GlobalVariablesImplement grobalVariables;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton printButton;
    private JScrollPane scrollPane;
    private JTable table;

    public DirectionDialog(Frame parent, boolean modal, DocumentModel model) {
        super(parent, modal);
        this.directionsList[0] = "\u51e6\u65b9";
        this.directionsList[1] = "\u6ce8\u5c04";
        this.directionsList[2] = "\u51e6\u7f6e";
        this.directionsList[3] = "\u624b\u8853";
        this.directionsList[4] = "\u691c\u67fb";
        this.directionsList[5] = "\u753b\u50cf\u8a3a\u65ad";
        this.directionsList[6] = "\u305d\u306e\u4ed6";
        this.directionsList[7] = "\u306a\u3057";
        this.documentModel = model;
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.buttonPanel = new JPanel();
        this.printButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u6307\u793a\u7b8b\u5370\u5237");
        this.scrollPane.setName("scrollPane");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"\u6307\u793a", "\u9001\u4ed8\u5148"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setName("table");
        this.scrollPane.setViewportView(this.table);
        this.buttonPanel.setName("buttonPanel");
        this.printButton.setText("\u9001\u308b");
        this.printButton.setName("printButton");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectionDialog.this.printButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("\u9589\u3058\u308b");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addContainerGap(308, Short.MAX_VALUE).addComponent(this.printButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(7, 7, 7)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addContainerGap().addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.printButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPane, -1, 436, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPane, -1, 181, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonPanel, -2, -1, -2)));
        this.pack();
    }

    private void PrintTask(final String assignment, final String description, final int clusterIndex) {
        ApplicationContext context = GlobalConstants.getApplicationContext();
        Task<Void, Void> task = new Task<Void, Void>(context.getApplication()){

            protected Void doInBackground() throws Exception {
                PrintService service = DirectionDialog.this.tableModel.findPrinter(assignment, clusterIndex);
                List modules = DirectionDialog.this.tableModel.getModules(assignment);
                if (!modules.isEmpty() && service != null) {
                    PrintDirection printDirection = new PrintDirection(service.createPrintJob(), assignment, modules, DirectionDialog.this.grobalVariables, description, 60, 60);
                }
                return null;
            }

            protected void succeeded(Void result) {
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        context.getTaskService().execute((Task)task);
    }

    private void printDocument(String assignment, String description, int clusterIndex) {
        this.PrintTask(assignment, description, clusterIndex);
    }

    private void printAll() {
        for (int index = 0; index < this.directionsList.length; ++index) {
            this.printDocument(this.directionsList[index], "", 0);
            this.printDocument(this.directionsList[index], "\uff08\u63a7\u3048\uff09", 1);
        }
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        this.printAll();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void initCustomComponents() {
        this.scrollPane.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.tableModel = new DirectionTableModel(this.documentModel.getModules());
        this.table.setModel(this.tableModel);
        JComboBox<String> numberCombo = new JComboBox<String>(this.directionsList);
        TableColumn numberColumn = this.table.getColumnModel().getColumn(1);
        numberColumn.setCellEditor(new DefaultCellEditor(numberCombo));
    }

    private class PrintDirection
    implements Printable {
        private List<ModuleModel> models;
        private String assignment;
        private GlobalVariablesImplement globalVariables;
        private String description;
        private List<Integer> modelIndexPerPage;
        private int top_margin;
        private int left_margin;

        public PrintDirection(DocPrintJob job, String assignment, List<ModuleModel> models, GlobalVariablesImplement grobalVariables, String description, int top_margin, int left_margin) {
            this.globalVariables = grobalVariables;
            this.models = models;
            this.assignment = assignment;
            this.description = description;
            this.top_margin = top_margin;
            this.left_margin = left_margin;
            this.modelIndexPerPage = new ArrayList<Integer>();
            HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
            attributes.add(new JobName(assignment, null));
            attributes.add(new Copies(1));
            attributes.add(MediaSizeName.ISO_A4);
            attributes.add(OrientationRequested.PORTRAIT);
            try {
                SimpleDoc document = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
                job.print(document, attributes);
            }
            catch (PrintException e) {
                // empty catch block
            }
        }

        private String getUserID() {
            return this.globalVariables.getUserId();
        }

        private UserModel getUserModel() {
            return this.globalVariables.getUserModel();
        }

        private boolean hasKarte() {
            return this.models.size() > 0;
        }

        private KarteBean getKarte() {
            KarteBean result = null;
            if (this.hasKarte()) {
                result = this.models.get(0).getKarte();
            }
            return result;
        }

        private PatientModel getPatient() {
            PatientModel result = null;
            KarteBean karte = this.getKarte();
            if (karte != null) {
                result = this.getKarte().getPatient();
            }
            return result;
        }

        private String getItemName(ClaimItem item) {
            return item.getName();
        }

        private String getItemCount(ClaimItem item) {
            String result = "";
            String item_count = item.getNumber();
            String item_unit = item.getUnit();
            if (item_count != null) {
                result = result + item_count;
            }
            if (item_unit != null) {
                result = result + item_unit;
            }
            return result;
        }

        private void drawLine(Graphics2D page, int x1, int y1, int x2, int y2, float thickness) {
            Stroke current = page.getStroke();
            page.setStroke(new BasicStroke(thickness));
            page.drawLine(x1, y1, x2, y2);
            page.setStroke(current);
        }

        private void drawRect(Graphics2D page, int x, int y, int width, int height, float thickness) {
            Stroke current = page.getStroke();
            page.setStroke(new BasicStroke(thickness));
            page.drawRect(x, y, width, height);
            page.setStroke(current);
        }

        private void drawString(Graphics2D page, int x, int y, String str, Font font) {
            Font current = page.getFont();
            page.setFont(font);
            page.drawString(str, x, y);
            page.setFont(current);
        }

        private int printUser(Graphics2D page, int top) {
            top += 15;
            if (page != null) {
                UserModel user = this.getUserModel();
                this.drawString(page, 10 + this.left_margin, top, this.getUserID() + " " + user.getLicenseModel().getLicenseDesc() + " " + user.getDepartmentModel().getDepartmentDesc() + " " + user.getFacility().getFacilityName(), new Font(null, 0, 10));
            }
            return top;
        }

        private int printDate(Graphics2D page, int top) {
            top += 15;
            if (page != null) {
                Date now = new Date();
                this.drawString(page, 10 + this.left_margin, top, now.toString(), new Font(null, 0, 10));
            }
            return top;
        }

        private int printPatient(Graphics2D page, int top) {
            top += 10;
            if (page != null) {
                this.drawString(page, 60 + this.left_margin, top, this.getPatient().getKanaName(), new Font("SansSerif", 1, 6));
            }
            top += 14;
            if (page != null) {
                this.drawString(page, 15 + this.left_margin, top, this.getPatient().getPatientId(), new Font("SansSerif", 1, 12));
                this.drawString(page, 60 + this.left_margin, top, this.getPatient().getFullName() + "  " + this.getPatient().getGenderDesc() + "  " + this.getPatient().getAgeBirthday(), new Font("SansSerif", 1, 12));
            }
            return top;
        }

        private int printLine(Graphics2D page, int length, int top) {
            top += 8;
            if (page != null) {
                page.drawLine(10 + this.left_margin, top, length, top);
            }
            return top;
        }

        private int printSignatureRect(Graphics2D page, int top) {
            if (page != null) {
                this.drawRect(page, 390 + this.left_margin, 15 + this.top_margin, 56, 56, 2.0f);
            }
            return top;
        }

        private int printTitle(Graphics2D page, int top, int currentPage, int pageCount) {
            if (page != null) {
                String pageName = "";
                if (pageCount != 1) {
                    pageName = "(" + Integer.toString(currentPage + 1) + "/" + Integer.toString(pageCount) + ")";
                }
                this.drawString(page, 10 + this.left_margin, top, this.assignment + "\u7b8b " + pageName, new Font(null, 0, 20));
                this.drawString(page, 400 + this.left_margin, top, this.description, new Font(null, 0, 8));
            }
            return top;
        }

        private int printHeader(Graphics2D page, int top, int currentPage, int pageCount) {
            top = this.printTitle(page, top, currentPage, pageCount);
            top = this.printLine(page, 460 + this.left_margin, top);
            top = this.printUser(page, top);
            top = this.printDate(page, top);
            top = this.printLine(page, 380 + this.left_margin, top);
            top = this.printPatient(page, top);
            top = this.printSignatureRect(page, top);
            top = this.printLine(page, 460 + this.left_margin, top);
            return top += 22;
        }

        private int printStampName(Graphics2D page, ModuleModel model, int top) {
            top += 25;
            if (page != null) {
                String stampName = model.getModuleInfo().getStampName();
                this.drawRect(page, 20 + this.left_margin, top - 9, 9, 9, 1.2f);
                this.drawString(page, 30 + this.left_margin, top, stampName, new Font("SansSerif", 1, 10));
                this.drawLine(page, 20 + this.left_margin, top + 4, 440 + this.left_margin, top + 4, 0.5f);
            }
            return top;
        }

        private int printItem(Graphics2D page, ClaimItem item, int top) {
            top += 15;
            if (page != null && this.getItemName(item) != null) {
                this.drawRect(page, 35 + this.left_margin, top - 8, 8, 8, 0.8f);
                this.drawString(page, 45 + this.left_margin, top, this.getItemName(item), new Font(null, 0, 10));
                this.drawString(page, 400 + this.left_margin, top, this.getItemCount(item), new Font(null, 0, 10));
            }
            return top;
        }

        private int printAdmin(Graphics2D page, ClaimBundle bundle, int top) {
            String admin = bundle.getAdmin();
            String bundleNumber = bundle.getBundleNumber();
            if (admin != null) {
                if (bundleNumber == null) {
                    bundleNumber = "";
                }
                top += 6;
                if (page != null) {
                    this.drawRect(page, 35 + this.left_margin, top, 390, 20, 0.2f);
                }
                top += 14;
                if (page != null) {
                    this.drawString(page, 45 + this.left_margin, top, admin, new Font(null, 0, 10));
                    this.drawString(page, 400 + this.left_margin, top, bundleNumber, new Font(null, 0, 10));
                }
            }
            return top;
        }

        private int printStamp(Graphics2D page, int modelIndex, int top) {
            top = this.printStampName(page, this.models.get(modelIndex), top);
            ClaimBundle bundle = (ClaimBundle)this.models.get(modelIndex).getModel();
            ClaimItem[] item = bundle.getClaimItem();
            for (int itemIndex = 0; itemIndex < item.length; ++itemIndex) {
                top = this.printItem(page, item[itemIndex], top);
            }
            top = this.printAdmin(page, bundle, top);
            return top;
        }

        private int measureHeaderSize(int top, int currentPage, int pageCount) {
            return this.printHeader(null, top, currentPage, pageCount);
        }

        private int measureStampSize(int modelIndex, int top) {
            return this.printStamp(null, modelIndex, top);
        }

        private boolean printPage(Graphics2D page, double pageLength, int currentPage, int pageCount) {
            if (currentPage < this.modelIndexPerPage.size() && this.modelIndexPerPage.get(currentPage) < this.models.size()) {
                int top = this.top_margin;
                top = this.printHeader(page, top, currentPage, pageCount);
                for (int modelCount = this.modelIndexPerPage.get(currentPage).intValue(); modelCount < this.models.size() && (double)this.measureStampSize(modelCount, top) < pageLength; ++modelCount) {
                    top = this.printStamp(page, modelCount, top);
                }
                return true;
            }
            return false;
        }

        private int measurePageSize(int currentIndex, double pageLength, int currentPage) {
            int top = this.top_margin;
            top = this.measureHeaderSize(top, currentPage, 0);
            while (currentIndex < this.models.size()) {
                if ((double)(top = this.measureStampSize(currentIndex, top)) >= pageLength) {
                    this.modelIndexPerPage.add(currentIndex);
                    break;
                }
                ++currentIndex;
            }
            return currentIndex;
        }

        private int measure(double pageLength) {
            int currentIndex = 0;
            int currentPage = 0;
            this.modelIndexPerPage.clear();
            this.modelIndexPerPage.add(0);
            do {
                currentIndex = this.measurePageSize(currentIndex, pageLength, currentPage);
                ++currentPage;
            } while (currentIndex < this.models.size());
            return currentPage;
        }

        @Override
        public int print(Graphics graphics, PageFormat format, int pageIndex) {
            Graphics2D page = (Graphics2D)graphics;
            page.translate(format.getImageableX(), format.getImageableY());
            page.setColor(Color.black);
            int pages = this.measure(format.getImageableHeight() - (double)this.top_margin);
            if (this.printPage(page, format.getImageableHeight() - (double)this.top_margin, pageIndex, pages)) {
                return 0;
            }
            return 1;
        }
    }

    private class DirectionTableModel
    extends AbstractTableModel {
        private List<ModuleModel> modules;
        private List<String> assignment;
        private List<CombinedStringParser> printerClusters = new ArrayList<CombinedStringParser>();

        public DirectionTableModel(Collection<ModuleModel> bundle) {
            this.printerClusters.add(GlobalVariables.getDirections());
            this.printerClusters.add(GlobalVariables.getCcDirections());
            this.modules = new ArrayList<ModuleModel>();
            this.assignment = new ArrayList<String>();
            this.initModel(bundle);
        }

        private void initModel(Collection<ModuleModel> bundle) {
            for (ModuleModel stamp : bundle) {
                if (stamp.getModuleInfo().getEntity().equals("medOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[0], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("injectionOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[1], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("treatmentOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[2], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("surgeryOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[3], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("testOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[4], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("physiologyOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[4], stamp);
                    continue;
                }
                if (stamp.getModuleInfo().getEntity().equals("radiologyOrder")) {
                    this.addModelItems(DirectionDialog.this.directionsList[5], stamp);
                    continue;
                }
                if (!stamp.getModuleInfo().getEntity().equals("otherOrder")) continue;
                this.addModelItems(DirectionDialog.this.directionsList[6], stamp);
            }
        }

        private PrintService findPrinter(String assignment_name, int clusterIndex) {
            for (int assignment_index = 0; assignment_index < DirectionDialog.this.directionsList.length; ++assignment_index) {
                if (!DirectionDialog.this.directionsList[assignment_index].equals(assignment_name)) continue;
                return this.findPrinterByName(this.printerClusters.get(clusterIndex).get(assignment_index));
            }
            return null;
        }

        private PrintService findPrinterByName(String printer_name) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            for (int printers_index = 0; printers_index < services.length; ++printers_index) {
                if (!services[printers_index].getName().equals(printer_name)) continue;
                return services[printers_index];
            }
            return null;
        }

        private void addModelItems(String name, ModuleModel model) {
            this.modules.add(model);
            this.assignment.add(name);
        }

        private List<ModuleModel> getModules(String name) {
            ArrayList<ModuleModel> result = new ArrayList<ModuleModel>();
            for (int index = 0; index < this.assignment.size(); ++index) {
                if (!this.assignment.get(index).equals(name)) continue;
                result.add(this.modules.get(index));
            }
            return result;
        }

        public ModuleModel getStamp(int index) {
            return this.modules.get(index);
        }

        public String getAssignment(int index) {
            return this.assignment.get(index);
        }

        @Override
        public int getRowCount() {
            return this.modules.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = "\u6307\u793a";
                    break;
                }
                case 1: {
                    result = "\u9001\u308a\u5148";
                    break;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = ((ModuleModel)this.modules.toArray()[rowIndex]).getModuleInfo().getStampName();
                    break;
                }
                case 1: {
                    result = this.assignment.get(rowIndex);
                    break;
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.assignment.set(rowIndex, (String)aValue);
        }
    }
}

