/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import open.dolphin.client.DoBodyObject;
import open.dolphin.client.DoHeaderObject;
import open.dolphin.client.DoTransferHandler;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.project.GlobalConstants;

public class DoPanel
extends JPanel
implements PropertyChangeListener,
IChartDocument,
IChartCommandAccepter {
    public static final String TITLE = "ORCA Do";
    private IChart parent;
    private String title = "ORCA Do";
    private boolean dirty;
    private DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    String patientID;
    private static final ImageIcon LOCAL_ICON = GlobalConstants.getImageIcon("move2_16.gif");
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JScrollPane jScrollPane1;
    private JTree tree;

    public DoPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.root = new DefaultMutableTreeNode();
        this.patientID = parent.getPatient().getPatientId();
        DoTransferHandler transferHandler = new DoTransferHandler();
        this.tree.setTransferHandler(transferHandler);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree.setModel(this.treeModel);
        final TreeCellRenderer oldRenderer = this.tree.getCellRenderer();
        TreeCellRenderer r = new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component cellRenderer = oldRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (leaf && cellRenderer instanceof JLabel) {
                    JLabel label = (JLabel)cellRenderer;
                    label.setIcon(LOCAL_ICON);
                }
                return cellRenderer;
            }
        };
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox2.setName("jComboBox2");
        this.jScrollPane1.setName("jScrollPane1");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.tree.setDragEnabled(true);
        this.tree.setName("tree");
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox1, -2, 112, -2).addGap(164, 164, 164).addComponent(this.jComboBox2, -2, 100, -2)).addComponent(this.jScrollPane1, -2, 497, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jComboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 235, Short.MAX_VALUE)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.DoPanel;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode root, DoBodyObject record) {
        DefaultMutableTreeNode currentNode = null;
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            String key2;
            currentNode = (DefaultMutableTreeNode)e.nextElement();
            String key = ((DoHeaderObject)currentNode.getUserObject()).getKey();
            if (!key.equals(key2 = record.getKey())) continue;
            return currentNode;
        }
        return null;
    }

    private void addNode(DefaultMutableTreeNode node, DoBodyObject record) {
        if (record.valid()) {
            DefaultMutableTreeNode newLeaf = new DefaultMutableTreeNode();
            newLeaf.setUserObject(record);
            node.add(newLeaf);
        }
    }

    @Override
    public void start() {
        List<DoBodyObject> result = null;
        SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        result = dao.get_TBL_SRYACT(this.patientID);
        for (DoBodyObject record : result) {
            DefaultMutableTreeNode currentNode = this.findNode(this.root, record);
            if (currentNode == null) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
                newNode.setUserObject(record.toDoHeaderObject());
                this.root.add(newNode);
                this.addNode(newNode, record);
                continue;
            }
            this.addNode(currentNode, record);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }
}

