/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import open.dolphin.client.SchemaHolder;
import open.dolphin.client.editor.stamp.StampHolder;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;

public class KartePaneDumper {
    private static final String[] MATCHES = new String[]{"<", ">", "&", "'", "\""};
    private static final String[] REPLACES = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private List<ModuleModel> moduleList;
    private List<SchemaModel> schemaList;
    private String spec;

    public String getSpec() {
        LogWriter.debug(this.getClass(), this.spec);
        return this.spec;
    }

    public ModuleModel[] getModules() {
        ModuleModel[] ret = null;
        if (this.moduleList != null && this.moduleList.size() > 0) {
            ret = this.moduleList.toArray(new ModuleModel[this.moduleList.size()]);
        }
        return ret;
    }

    public SchemaModel[] getSchemas() {
        SchemaModel[] schemas = null;
        if (this.schemaList != null && this.schemaList.size() > 0) {
            schemas = this.schemaList.toArray(new SchemaModel[this.schemaList.size()]);
        }
        return schemas;
    }

    public void dump(DefaultStyledDocument doc) {
        StringWriter sw = new StringWriter();
        BufferedWriter writer = new BufferedWriter(sw);
        try {
            Element root = doc.getDefaultRootElement();
            this.writeElemnt(root, writer);
            writer.flush();
            writer.close();
            this.spec = sw.toString();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void writeElemnt(Element element, Writer writer) throws IOException, BadLocationException {
        int start = element.getStartOffset();
        int end = element.getEndOffset();
        LogWriter.debug(this.getClass(), "start = " + start);
        LogWriter.debug(this.getClass(), "end = " + end);
        AttributeSet atts = element.getAttributes().copyAttributes();
        String asString = "";
        if (atts != null) {
            StringBuilder retBuffer = new StringBuilder();
            Enumeration<?> names = atts.getAttributeNames();
            while (names.hasMoreElements()) {
                String value;
                Object nextName = names.nextElement();
                if (nextName == StyleConstants.ResolveAttribute) continue;
                LogWriter.debug(KartePaneDumper.class, "attribute name = " + nextName.toString());
                if (nextName.toString().startsWith("$")) continue;
                retBuffer.append(" ");
                retBuffer.append(nextName);
                retBuffer.append("=");
                if (nextName.toString().equals("foreground")) {
                    Color c = (Color)atts.getAttribute(StyleConstants.Foreground);
                    LogWriter.debug(this.getClass(), "color = " + c.toString());
                    StringBuilder buf = new StringBuilder();
                    buf.append(String.valueOf(c.getRed()));
                    buf.append(",");
                    buf.append(String.valueOf(c.getGreen()));
                    buf.append(",");
                    buf.append(String.valueOf(c.getBlue()));
                    retBuffer.append(this.addQuote(buf.toString()));
                    continue;
                }
                Object attObject = atts.getAttribute(nextName);
                LogWriter.debug(this.getClass(), "attribute object = " + attObject.toString());
                if (attObject instanceof StampHolder) {
                    if (this.moduleList == null) {
                        this.moduleList = new ArrayList<ModuleModel>();
                    }
                    StampHolder sh = (StampHolder)attObject;
                    this.moduleList.add(sh.getStamp());
                    value = String.valueOf(this.moduleList.size() - 1);
                    retBuffer.append(this.addQuote(value));
                    continue;
                }
                if (attObject instanceof SchemaHolder) {
                    if (this.schemaList == null) {
                        this.schemaList = new ArrayList<SchemaModel>();
                    }
                    SchemaHolder ch = (SchemaHolder)attObject;
                    this.schemaList.add(ch.getSchema());
                    value = String.valueOf(this.schemaList.size() - 1);
                    retBuffer.append(this.addQuote(value));
                    continue;
                }
                retBuffer.append(this.addQuote(attObject.toString()));
            }
            asString = retBuffer.toString();
        }
        writer.write("<");
        writer.write(element.getName());
        writer.write(" start=");
        writer.write(this.addQuote(start));
        writer.write(" end=");
        writer.write(this.addQuote(end));
        writer.write(asString);
        writer.write(">");
        if (element.getName().equals("content")) {
            writer.write("<text>");
            int len = end - start;
            String text = element.getDocument().getText(start, len);
            LogWriter.debug(this.getClass(), "text = " + text);
            for (int i = 0; i < REPLACES.length; ++i) {
                text = text.replaceAll(MATCHES[i], REPLACES[i]);
            }
            writer.write(text);
            writer.write("</text>");
        }
        int childreSize = element.getElementCount();
        for (int i = 0; i < childreSize; ++i) {
            this.writeElemnt(element.getElement(i), writer);
        }
        writer.write("</");
        writer.write(element.getName());
        writer.write(">");
    }

    private String addQuote(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append("\"");
        buf.append(str);
        buf.append("\"");
        return buf.toString();
    }

    private String addQuote(int str) {
        StringBuilder buf = new StringBuilder();
        buf.append("\"");
        buf.append(str);
        buf.append("\"");
        return buf.toString();
    }
}

