/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IKarteViewer;
import open.dolphin.client.KartePane;
import open.dolphin.client.KartePanelSingle;
import open.dolphin.client.KarteRenderer;
import open.dolphin.helper.KarteHeader;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class KarteViewerSingle
extends KartePanelSingle
implements Comparable,
IChartDocument,
IKarteViewer {
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title;
    private boolean dirty;
    private static final Color SELECTED_COLOR = new Color(255, 0, 153);
    private static final Border SELECTED_BORDER = BorderFactory.createLineBorder(SELECTED_COLOR);
    private static final Color NOT_SELECTED_COLOR = new Color(227, 250, 207);
    private static final Border NOT_SELECTED_BORDER = BorderFactory.createLineBorder(NOT_SELECTED_COLOR);
    private static final Color TIMESTAMP_FORE = Color.BLUE;
    private static final int TIMESTAMP_FONT_SIZE = 14;
    private static final Font TIMESTAMP_FONT = new Font("Dialog", 0, 14);
    private static final int TIMESTAMP_SPACING = 7;
    private String UNDER_TMP_SAVE = " - \u4eee\u4fdd\u5b58\u4e2d";
    private DocumentModel model;
    private JLabel timeStampLabel;
    private KartePane soaPane;
    private Color timeStampFore = TIMESTAMP_FORE;
    private Font timeStampFont = TIMESTAMP_FONT;
    private int timeStampSpacing = 7;
    private boolean avoidEnter;
    private boolean selected;
    private int mode;

    public KarteViewerSingle(IChart parent) {
        super(false);
        this.parent = parent;
        this.UNDER_TMP_SAVE = " - \u672a\u9001\u4fe1";
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.KarteViewerSingle;
    }

    public void initialize() {
        this.timeStampLabel = this.getTimeStampLabel();
        this.soaPane = new KartePane();
        this.soaPane.setTextPane(this.getSoaTextPane());
        this.soaPane.setRole("soa");
        if (this.model != null) {
            String docId = this.model.getDocInfo().getDocId();
            this.soaPane.setDocId(docId);
        }
    }

    @Override
    public int getActualHeight() {
        try {
            JTextPane pane = this.soaPane.getTextPane();
            int pos = pane.getDocument().getLength();
            Rectangle r = pane.modelToView(pos);
            int hsoa = r.y;
            return hsoa;
        }
        catch (BadLocationException ex) {
            LogWriter.error(this.getClass(), ex);
            return 0;
        }
    }

    public void adjustSize() {
        int h = this.getActualHeight();
        int soaWidth = this.soaPane.getTextPane().getPreferredSize().width;
        this.soaPane.getTextPane().setPreferredSize(new Dimension(soaWidth, h));
    }

    @Override
    public String getDocType() {
        if (this.model != null) {
            String docType = this.model.getDocInfo().getDocType();
            return docType;
        }
        return null;
    }

    @Override
    public void setAvoidEnter(boolean b) {
        this.avoidEnter = b;
    }

    @Override
    public void printPanel2(PageFormat format) {
        String name = this.getParentContext().getPatient().getFullName();
        this.printPanel(format, 1, false, name, this.getActualHeight() + 30);
    }

    @Override
    public void printPanel2(PageFormat format, int copies, boolean useDialog) {
        String name = this.getParentContext().getPatient().getFullName();
        this.printPanel(format, copies, useDialog, name, this.getActualHeight() + 30);
    }

    private boolean save() {
        return false;
    }

    private boolean print() {
        PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
        this.printPanel2(pageFormat);
        return true;
    }

    private boolean direction() {
        return false;
    }

    public KartePane getSOAPane() {
        return this.soaPane;
    }

    @Override
    public void enter() {
        if (!this.avoidEnter) {
            this.parent.getStatusPanel().setMessage("");
            this.getParentContext().getChartMediator().setAccepter(this);
            this.disableMenus();
            this.getParentContext().enabledAction("newKarte", true);
            this.getParentContext().enabledAction("newDocument", true);
            this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
            boolean canEdit = !this.getParentContext().isReadOnly();
            boolean tmp = this.model.getDocInfo().getStatus().equals("T");
            boolean newOk = canEdit && !tmp;
            ChartMediator mediator = this.getParentContext().getChartMediator();
            mediator.enabledAction("newKarte", true);
            mediator.enabledAction("print", true);
            mediator.enabledAction("modifyKarte", canEdit);
        }
    }

    @Override
    public void start() {
        this.initialize();
        if (this.getModel() != null) {
            KarteHeader header = new KarteHeader(this.model, "\u53c2\u7167");
            String timeStamp = header.toString();
            this.timeStampLabel.setText(timeStamp);
            KarteRenderer renderer = new KarteRenderer(this.soaPane, null);
            renderer.render(this.model);
        }
        ChartMediator mediator = this.getParentContext().getChartMediator();
        this.soaPane.init(false, mediator);
        this.enter();
    }

    @Override
    public void stop() {
        this.soaPane.clear();
    }

    @Override
    public void setModel(DocumentModel model) {
        this.model = model;
    }

    @Override
    public DocumentModel getModel() {
        return this.model;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBorder(SELECTED_BORDER);
        } else {
            this.setBorder(NOT_SELECTED_BORDER);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        this.soaPane.getTextPane().addMouseListener(ml);
    }

    public int hashCode() {
        return this.getModel().getDocInfo().getDocId().hashCode() + 72;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DocInfoModel otheInfo = ((IKarteViewer)other).getModel().getDocInfo();
            return this.getModel().getDocInfo().equals(otheInfo);
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DocInfoModel otheInfo = ((IKarteViewer)other).getModel().getDocInfo();
            return this.getModel().getDocInfo().compareTo(otheInfo);
        }
        return -1;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case direction: {
                return this.direction();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    private void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }
}

