/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import open.dolphin.log.LogWriter;

public class RegexConstrainedDocument
extends PlainDocument {
    private static final long serialVersionUID = 4066321190740323979L;
    boolean beep;
    boolean debug;
    Pattern pattern;
    Matcher matcher;

    public RegexConstrainedDocument() {
    }

    public RegexConstrainedDocument(AbstractDocument.Content c) {
        super(c);
    }

    public RegexConstrainedDocument(AbstractDocument.Content c, String p) {
        super(c);
        this.setPatternByString(p);
    }

    public RegexConstrainedDocument(String p) {
        this.setPatternByString(p);
    }

    public void setPatternByString(String p) {
        Pattern _pattern = Pattern.compile(p);
        try {
            this.matcher = _pattern.matcher(this.getText(0, this.getLength()));
            this.debug("matcher reset to " + this.getText(0, this.getLength()));
            if (!this.matcher.matches()) {
                this.debug("does not match");
                this.remove(0, this.getLength());
            }
        }
        catch (BadLocationException ble) {
            LogWriter.error(this.getClass(), ble);
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void insertString(int offs, String s, AttributeSet a) throws BadLocationException {
        String proposedInsert = this.getText(0, this.getLength()) + s;
        this.debug("proposing to change to: " + proposedInsert);
        if (this.matcher != null) {
            this.matcher.reset(proposedInsert);
            this.debug("matcher reset");
            if (!this.matcher.matches()) {
                this.beep();
                this.debug("insert doesn't match");
                return;
            }
        }
        super.insertString(offs, s, a);
    }

    private void beep() {
        if (this.beep) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }
}

