/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte.template;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import open.dolphin.client.karte.template.Template;
import open.dolphin.client.karte.template.TemplateHeader;
import open.dolphin.client.karte.template.TemplateReadable;
import open.dolphin.client.karte.template.TemplateReader;
import open.dolphin.client.karte.template.TemplateWritable;
import open.dolphin.client.karte.template.TemplateWriter;
import open.dolphin.client.karte.template.error.CantReadTemplateException;
import open.dolphin.client.karte.template.error.CantWriteTemplateException;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.log.LogWriter;

public class TemplateManager {
    public static final String EXTENSION = ".template";
    private File directory;
    private List<File> files;
    private List<Template> templateList;
    private TemplateReadable reader;
    private TemplateWritable writer;

    public TemplateManager() {
        this(new File("."));
    }

    public TemplateManager(File directory) {
        this.directory = directory;
        this.files = this.getFiles();
        this.setReader(new TemplateReader());
        this.setWriter(new TemplateWriter());
        this.templateList = new ArrayList<Template>();
    }

    public void setReader(TemplateReadable reader) {
        this.reader = reader;
    }

    public void setWriter(TemplateWritable writer) {
        this.writer = writer;
    }

    public void createList() throws CantReadTemplateException {
        for (File file : this.files) {
            TemplateHeader header = this.reader.readHeader(file);
            header.setPath(file);
            this.templateList.add(new Template(this, header));
        }
    }

    public void updateList() throws CantReadTemplateException {
        this.updateFileList();
        this.createList();
    }

    public List<Template> getList() {
        if (this.templateList.size() == 0) {
            try {
                this.createList();
            }
            catch (CantReadTemplateException ex) {
                LogWriter.error(this.getClass(), "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ea\u30b9\u30c8\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\n" + ex.getStackTrace());
            }
        }
        return this.templateList;
    }

    public void readTemplate(Template template) throws CantReadTemplateException {
        template.setBody(this.reader.readBody(template.getHeader().getPath()));
    }

    public void writeTemplate(Template template) throws CantWriteTemplateException {
        this.writer.beginSession(template.getHeader().getPath());
        this.writer.writeHeader(template.getHeader());
        try {
            this.writer.writeBody(template.getBody());
        }
        catch (CantReadTemplateException ex) {
            throw new CantWriteTemplateException(ex);
        }
        this.writer.endSession();
    }

    public Template createTemplate(DocumentModel body) throws CantWriteTemplateException {
        Template template = new Template(this);
        TemplateHeader header = new TemplateHeader();
        header.setName(body.getDocInfo().getTitle());
        header.setCreator(body.getCreator().getCommonName());
        String format = "yyyyMMddHHmmss'.template'";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String fileName = formatter.format(new Date());
        header.setPath(new File(this.directory, fileName));
        template.setHeader(header);
        template.setBody(body);
        this.writeTemplate(template);
        return template;
    }

    private boolean isTemplateFile(File file) {
        return file.isFile() && file.getName().endsWith(EXTENSION);
    }

    protected File[] getFilesAsArray() {
        FileFilter templateFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return TemplateManager.this.isTemplateFile(file);
            }
        };
        return this.directory.listFiles(templateFilter);
    }

    private List<File> getFiles() {
        return new ArrayList<File>(Arrays.asList(this.getFilesAsArray()));
    }

    protected void updateFileList() {
        this.files = this.getFiles();
    }
}

