/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import open.dolphin.client.imagebrowserdocument.ImageBrowserDocumentPanel;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class BrowserSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    protected IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "imageBrowserSetting";
    private static final String TITLE = "\u753b\u50cf";
    private static final String ICON = "ntwrk_24.gif";
    private ApplicationContext appCtx;
    private Properties properties;
    private JButton baseDirBtn;
    private JTextField baseDirFld;
    private JSpinner columnSpinner;
    private JButton dicomBtn;
    private JTextField dicomFld;
    private JCheckBox fileNameChkBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton jpegBtn;
    private JTextField jpegFld;
    private JButton pdfBtn;
    private JTextField pdfFld;

    public BrowserSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dicomFld = new JTextField();
        this.pdfFld = new JTextField();
        this.jpegFld = new JTextField();
        this.jpegBtn = new JButton();
        this.pdfBtn = new JButton();
        this.dicomBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.baseDirFld = new JTextField();
        this.baseDirBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.columnSpinner = new JSpinner();
        this.jLabel6 = new JLabel();
        this.fileNameChkBox = new JCheckBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("\u753b\u50cf\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3068\u8d77\u52d5\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3"));
        this.jLabel2.setText("PDF:");
        this.jLabel1.setText("JPEG:");
        this.jLabel3.setText("DICOM:");
        this.dicomFld.setEditable(false);
        this.dicomFld.setText("/Applications/ImageJ/ImageJ.app");
        this.dicomFld.setToolTipText("DICOM\u753b\u50cf\u3092\u8868\u793a\u3059\u308b\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u793a\u3057\u307e\u3059\u3002");
        this.pdfFld.setEditable(false);
        this.pdfFld.setToolTipText("PDF\u6587\u66f8\u3092\u8868\u793a\u3059\u308b\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u793a\u3057\u307e\u3059\u3002");
        this.jpegFld.setEditable(false);
        this.jpegFld.setToolTipText("JPEG\u753b\u50cf\u3092\u8868\u793a\u3059\u308b\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u793a\u3057\u307e\u3059\u3002");
        this.jpegBtn.setText("\u8a2d\u5b9a...");
        this.jpegBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserSettingPanel.this.jpegBtnActionPerformed(evt);
            }
        });
        this.pdfBtn.setText("\u8a2d\u5b9a...");
        this.pdfBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserSettingPanel.this.pdfBtnActionPerformed(evt);
            }
        });
        this.dicomBtn.setText("\u8a2d\u5b9a...");
        this.dicomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserSettingPanel.this.dicomBtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.jpegFld, -1, 382, Short.MAX_VALUE).add(2, (Component)this.pdfFld, -1, 382, Short.MAX_VALUE).add((Component)this.dicomFld, -1, 382, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jpegBtn).add((Component)this.pdfBtn).add((Component)this.dicomBtn))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jpegBtn).add((Component)this.jpegFld, -2, -1, -2)).add(9, 9, 9).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.pdfBtn).add((Component)this.pdfFld, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.dicomBtn).add((Component)this.dicomFld, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("\u753b\u50cf\u30fbPDF\u6587\u66f8\u306e\u5834\u6240"));
        this.jLabel4.setText("\u30d9\u30fc\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea:");
        this.baseDirBtn.setText("\u8a2d\u5b9a...");
        this.baseDirBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserSettingPanel.this.baseDirBtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.baseDirFld, -1, 288, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.baseDirBtn)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.baseDirFld, -2, 28, -2).add((Component)this.baseDirBtn)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("\u8868\u793a"));
        this.jLabel5.setText("\u753b\u50cf\u30c6\u30fc\u30d6\u30eb\u306e\u30ab\u30e9\u30e0\u6570:");
        this.columnSpinner.setModel(new SpinnerNumberModel(5, 1, 10, 1));
        this.jLabel6.setText("\u30d5\u30a1\u30a4\u30eb\u540d\u8868\u793a:");
        this.fileNameChkBox.setText("\u6709");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.columnSpinner, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.fileNameChkBox).addContainerGap(122, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.columnSpinner, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.fileNameChkBox)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -2, -1, -2).add(10, 10, 10).add((Component)this.jPanel2, -2, -1, -2).add(10, 10, 10).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void baseDirBtnActionPerformed(ActionEvent evt) {
        this.setBaseDirectory();
    }

    private void jpegBtnActionPerformed(ActionEvent evt) {
        this.setJepgView();
    }

    private void pdfBtnActionPerformed(ActionEvent evt) {
        this.setPdfView();
    }

    private void dicomBtnActionPerformed(ActionEvent evt) {
        this.setDicomView();
    }

    private String selectApp() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            String app = chooser.getSelectedFile().getPath();
            return app;
        }
        return null;
    }

    @Action
    public void setBaseDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            String dir = chooser.getSelectedFile().getPath();
            this.baseDirFld.setText(dir);
        }
    }

    @Action
    public void setJepgView() {
        String app = this.selectApp();
        if (app != null) {
            this.jpegFld.setText(app);
        }
    }

    @Action
    public void setPdfView() {
        String app = this.selectApp();
        if (app != null) {
            this.pdfFld.setText(app);
        }
    }

    @Action
    public void setDicomView() {
        String app = this.selectApp();
        if (app != null) {
            this.dicomFld.setText(app);
        }
    }

    @Action
    public void saveProperties() {
        String spiVal = this.columnSpinner.getValue().toString();
        this.properties.setProperty("columnCount", spiVal);
        String boolVal = String.valueOf(this.fileNameChkBox.isSelected());
        this.properties.setProperty("showFileName", boolVal);
        String baseVal = this.baseDirFld.getText().trim();
        this.properties.setProperty("baseDir", baseVal);
        this.properties.setProperty("jpegView", this.jpegFld.getText().trim());
        this.properties.setProperty("pdfView", this.pdfFld.getText().trim());
        this.properties.setProperty("dicomView", this.dicomFld.getText().trim());
        LocalStorage ls = this.appCtx.getLocalStorage();
        try {
            ls.save((Object)this.properties, "imageBrowserProp.xml");
        }
        catch (IOException ex) {
            Logger.getLogger(BrowserSettingPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Action
    public void cancel() {
    }

    @Override
    public void start() {
        this.loadResources();
        this.initCustomComponents();
    }

    private void initCustomComponents() {
        String spiVal = this.properties.getProperty("columnCount");
        int spiInt = Integer.parseInt(spiVal);
        this.columnSpinner.setValue(new Integer(spiInt));
        Boolean boolVal = Boolean.parseBoolean(this.properties.getProperty("showFileName"));
        this.fileNameChkBox.setSelected(boolVal);
        String baseDir = this.properties.getProperty("baseDir");
        this.baseDirFld.setText(baseDir);
        this.jpegFld.setText(this.properties.getProperty("jpegView"));
        this.pdfFld.setText(this.properties.getProperty("pdfView"));
        this.dicomFld.setText(this.properties.getProperty("dicomView"));
    }

    private void loadResources() {
        this.appCtx = GlobalConstants.getApplicationContext();
        ApplicationActionMap map = this.appCtx.getActionMap((Object)this);
        ResourceMap resource = this.appCtx.getResourceMap(ImageBrowserDocumentPanel.class);
        try {
            LocalStorage ls = this.appCtx.getLocalStorage();
            this.properties = (Properties)ls.load("imageBrowserProp.xml");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.properties == null) {
            String jpegView;
            this.properties = new Properties();
            this.properties.setProperty("columnCount", "5");
            this.properties.setProperty("showFileName", "true");
            this.properties.setProperty("baseDir", "");
            if (GlobalConstants.isMac()) {
                jpegView = resource.getString("jpegView.mac", new Object[0]);
                if (jpegView == null) {
                    jpegView = "";
                }
                this.properties.setProperty("jpegView", jpegView);
                String pdfView = resource.getString("pdfView.mac", new Object[0]);
                if (pdfView == null) {
                    pdfView = "";
                }
                this.properties.setProperty("pdfView", pdfView);
            } else if (GlobalConstants.isWin()) {
                jpegView = resource.getString("jpegView.win", new Object[0]);
                if (jpegView == null) {
                    jpegView = "";
                }
                this.properties.setProperty("jpegView", jpegView);
                String pdfView = resource.getString("pdfView.win", new Object[0]);
                if (pdfView == null) {
                    pdfView = "";
                }
                this.properties.setProperty("pdfView", pdfView);
            } else {
                this.properties.setProperty("jpegView", "");
                this.properties.setProperty("pdfView", "");
            }
            this.properties.setProperty("dicomView", "");
        }
    }

    @Override
    public void save() {
        this.saveProperties();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state) {
        this.state = state;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }
}

