/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import open.dolphin.dao.DaoBean;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class SqlDaoBean
extends DaoBean {
    String dataBase;
    String driver;
    boolean trace = true;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException cnfe) {
            LogWriter.warn(this.getClass(), "Couldn't find the driver!");
            LogWriter.warn(this.getClass(), "Let's print a stack trace, and exit.");
        }
    }

    public String getDatabase() {
        return this.dataBase;
    }

    public void setDatabase(String base) {
        this.dataBase = base;
    }

    protected String getURL() {
        StringBuffer buf = new StringBuffer();
        buf.append("jdbc:postgresql://");
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        buf.append("/");
        buf.append(this.dataBase);
        return buf.toString();
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean b) {
        this.trace = b;
    }

    public Connection getConnection() throws Exception {
        return DriverManager.getConnection(this.getURL(), this.user, this.passwd);
    }

    public String addSingleQuote(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("'");
        return buf.toString();
    }

    public String addSingleQuoteComa(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("',");
        return buf.toString();
    }

    public void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LogWriter.error(this.getClass(), e);
            }
        }
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                LogWriter.error(this.getClass(), e);
            }
        }
    }

    protected void debug(String msg) {
        LogWriter.debug(SqlDaoBean.class, msg);
    }

    protected void printTrace(String msg) {
        if (this.trace) {
            LogWriter.debug(SqlDaoBean.class, msg);
        }
    }

    protected int getHospNum() {
        Connection con = null;
        Statement st = null;
        String sql = null;
        int hospNum = 1;
        String jmari = GlobalVariables.getJMARICode();
        StringBuilder sb = new StringBuilder();
        sb.append("select hospnum, kanritbl from tbl_syskanri where kanricd='1001' and kanritbl like '%");
        sb.append(jmari);
        sb.append("%'");
        sql = sb.toString();
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                hospNum = rs.getInt(1);
            }
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
        }
        return hospNum;
    }
}

