/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.dao.SqlDaoBean;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.DiagnosisCategoryModel;
import open.dolphin.infomodel.DiagnosisOutcomeModel;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.order.ClaimConst;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.DebugDump;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class SqlOrcaView
extends SqlDaoBean {
    private static final String DRIVER = "org.postgresql.Driver";
    private static final int PORT = 5432;
    private static final String DATABASE = "orca";
    private static final String USER = "orca";
    private static final String PASSWD = "";

    public SqlOrcaView() {
        this.setDriver(DRIVER);
        this.setHost(GlobalVariables.getClaimAddress());
        this.setPort(5432);
        this.setDatabase("orca");
        this.setUser("orca");
        this.setPasswd(PASSWD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegisteredDiagnosisModel> getOrcaDisease(String patientId, String from, String to, Boolean isTenki, Boolean ascend) {
        try {
            ResultSet rs;
            this.semaphore.acquire();
            Connection con = null;
            ArrayList<RegisteredDiagnosisModel> collection = null;
            PreparedStatement pt = null;
            String sql = null;
            String ptid = null;
            int hospNum = -1;
            StringBuilder sb = new StringBuilder();
            sb.append("select ptid, ptnum from tbl_ptnum where ");
            if (GlobalVariables.getOrcaVersion().startsWith("4")) {
                hospNum = this.getHospNum();
                sb.append("hospnum=? and ptnum=?");
            } else {
                sb.append("ptnum=?");
            }
            sql = sb.toString();
            try {
                con = this.getConnection();
                pt = con.prepareStatement(sql);
                if (hospNum > 0) {
                    pt.setInt(1, hospNum);
                    pt.setString(2, patientId);
                } else {
                    pt.setString(1, patientId);
                }
                if (GlobalSettings.isSqlDump()) {
                    DebugDump.dump("orcaviewquery1.log", pt.toString());
                }
                if ((rs = pt.executeQuery()).next()) {
                    ptid = rs.getString(1);
                }
                this.closeConnection(con);
                this.closeStatement(pt);
            }
            catch (Exception e) {
                this.processError(e);
                this.closeConnection(con);
                this.closeStatement(pt);
            }
            if (ptid == null) {
                List<RegisteredDiagnosisModel> e = null;
                return e;
            }
            sb = new StringBuilder();
            if (isTenki.booleanValue()) {
                if (ascend.booleanValue()) {
                    if (hospNum > 0) {
                        sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where hospnum=?::numeric and ptid=?::numeric and tenkikbn='' order by sryymd asc");
                    } else {
                        sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where ptid=?::numeric and tenkikbn='' order by sryymd asc");
                    }
                } else if (hospNum > 0) {
                    sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where hospnum=?::numeric and ptid=?::numeric and tenkikbn='' order by sryymd desc");
                } else {
                    sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where ptid=?::numeric and tenkikbn='' order by sryymd desc");
                }
            } else if (ascend.booleanValue()) {
                if (hospNum > 0) {
                    sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where hospnum=?::numeric and ptid=?::numeric and sryymd >= ? and sryymd <= ? order by sryymd asc");
                } else {
                    sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where ptid=?::numeric and sryymd >= ? and sryymd <= ? order by sryymd asc");
                }
            } else if (hospNum > 0) {
                sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where hospnum=?::numeric and ptid=?::numeric and sryymd >= ? and sryymd <= ? order by sryymd desc");
            } else {
                sb.append("select sryymd,khnbyomeicd,tenkikbn,tenkiymd,byomei,utagaiflg,syubyoflg from tbl_ptbyomei where ptid=?::numeric and sryymd >= ? and sryymd <= ? order by sryymd desc");
            }
            sql = sb.toString();
            try {
                con = this.getConnection();
                pt = con.prepareStatement(sql);
                if (isTenki.booleanValue()) {
                    if (hospNum > 0) {
                        pt.setInt(1, hospNum);
                        pt.setString(2, ptid);
                    } else {
                        pt.setString(1, ptid);
                    }
                } else if (hospNum > 0) {
                    pt.setInt(1, hospNum);
                    pt.setString(2, ptid);
                    pt.setString(3, from);
                    pt.setString(4, to);
                } else {
                    pt.setString(1, ptid);
                    pt.setString(2, from);
                    pt.setString(3, to);
                }
                if (GlobalSettings.isSqlDump()) {
                    DebugDump.dump("orcaviewquery2.log", pt.toString());
                }
                rs = pt.executeQuery();
                collection = new ArrayList<RegisteredDiagnosisModel>();
                while (rs.next()) {
                    RegisteredDiagnosisModel ord = new RegisteredDiagnosisModel();
                    ord.setStartDate(this.toDolphinDateStr(rs.getString(1)));
                    ord.setDiagnosisCode(rs.getString(2));
                    DiagnosisOutcomeModel out = new DiagnosisOutcomeModel();
                    ord.setDiagnosisOutcomeModel(out);
                    String data = rs.getString(3);
                    out.setOutcomeDesc(this.toDolphinOutcome(data));
                    ord.setEndDate(this.toDolphinDateStr(rs.getString(4)));
                    ord.setDiagnosis(rs.getString(5));
                    String[] descs = new String[]{"\u4e3b\u75c5\u540d", "\u7591\u3044\u75c5\u540d"};
                    String[] codeSys = new String[]{"MML0012", "MML0015"};
                    DiagnosisCategoryModel dcm = new DiagnosisCategoryModel();
                    if ("1".equals(rs.getString(7))) {
                        dcm.setDiagnosisCategoryDesc(descs[0]);
                        dcm.setDiagnosisCategoryCodeSys(codeSys[0]);
                    }
                    ord.setDiagnosisCategoryModel(dcm);
                    ord.setStatus("ORCA");
                    ord.setDiagnosisCode(this.search(ord.getDiagnosis()));
                    collection.add(ord);
                }
                rs.close();
                this.closeStatement(pt);
                this.closeConnection(con);
                ArrayList<RegisteredDiagnosisModel> arrayList = collection;
                return arrayList;
            }
            catch (Exception e) {
                try {
                    this.processError(e);
                    this.closeConnection(con);
                    this.closeStatement(pt);
                    this.semaphore.release();
                }
                catch (InterruptedException ex) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.semaphore.release();
        }
        return null;
    }

    private String search(String text) {
        SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        String master = ClaimConst.MasterSet.DIAGNOSIS.getName();
        String sortBy = "byomeikana";
        String order = PASSWD;
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        List result = dao.getByName(master, text, true, ClaimConst.SubTypeSet.NAMES.getName(), "byomeikana", PASSWD);
        CombinedStringParser c = new CombinedStringParser();
        for (DiseaseEntry e : result) {
            c.add(e.getCode());
        }
        return c.toCombinedString();
    }

    private String toDolphinDateStr(String orcaDate) {
        if (orcaDate != null) {
            boolean digit = true;
            for (int i = 0; i < orcaDate.length(); ++i) {
                if (Character.isDigit(orcaDate.charAt(i))) continue;
                digit = false;
                break;
            }
            if (!digit) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(orcaDate.substring(0, 4));
            sb.append("-");
            sb.append(orcaDate.substring(4, 6));
            sb.append("-");
            sb.append(orcaDate.substring(6));
            return sb.toString();
        }
        return null;
    }

    private String toDolphinOutcome(String orcaOutcome) {
        if (orcaOutcome != null) {
            String outcomeDesc = null;
            if (orcaOutcome.equals("1")) {
                outcomeDesc = "\u6cbb\u7652";
            } else if (orcaOutcome.equals("2")) {
                outcomeDesc = "\u6b7b\u4ea1";
            } else if (orcaOutcome.equals("3")) {
                outcomeDesc = "\u4e2d\u6b62";
            } else if (orcaOutcome.equals("8")) {
                outcomeDesc = "\u79fb\u884c";
            }
            return outcomeDesc;
        }
        return null;
    }
}

