/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import open.dolphin.delegater.BusinessDelegater;
import open.dolphin.dto.AppointSpec;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.service.IAppointmentService;

public abstract class AppointmentDelegater
extends BusinessDelegater {
    protected abstract IAppointmentService getService() throws NamingException;

    public int putAppointments(List results) {
        int size = results.size();
        ArrayList<AppointmentModel> added = new ArrayList<AppointmentModel>();
        ArrayList<AppointmentModel> updated = new ArrayList<AppointmentModel>();
        ArrayList<AppointmentModel> removed = new ArrayList<AppointmentModel>();
        for (int i = 0; i < size; ++i) {
            AppointmentModel model = (AppointmentModel)results.get(i);
            int state = model.getState();
            String appoName = model.getName();
            if (state == 1) {
                added.add(model);
                continue;
            }
            if (state == 3 && appoName != null) {
                updated.add(model);
                continue;
            }
            if (state != 3 || appoName != null) continue;
            removed.add(model);
        }
        int retCode = 0;
        AppointSpec spec = new AppointSpec();
        spec.setAdded(added);
        spec.setUpdared(updated);
        spec.setRemoved(removed);
        try {
            this.getService().putAppointments(spec);
        }
        catch (Exception e) {
            this.processError(e);
        }
        return retCode;
    }
}

