/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import open.dolphin.infomodel.GenericAdapter;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.DateExpire;
import open.dolphin.utils.StringTool;

public class ClaimItem
extends InfoModel {
    private String name;
    private String code;
    private String codeSystem;
    private String classCode;
    private String classCodeSystem;
    private String number;
    private String unit;
    private String numberCode;
    private String numberCodeSystem;
    private String memo;
    private String ykzkbn;
    private List<String> sstKijunCdSet;
    private float suryo1;
    private float suryo2;
    private String startDate;
    private String endDate;

    public ClaimItem() {
        if (this.numberCodeSystem == null) {
            CombinedStringParser line = new CombinedStringParser('|', "");
            line.limit(4);
            line.set(0, "");
            line.set(1, "");
            line.set(2, "");
            line.set(3, "");
            this.numberCodeSystem = line.toCombinedString();
        } else {
            CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
            line.limit(4);
            line.set(1, "");
            line.set(2, "");
            line.set(3, "");
            this.numberCodeSystem = line.toCombinedString();
        }
    }

    public ClaimItem(MasterItem item) {
        this();
        this.setCode(item.getCode());
        this.setName(item.getName());
        this.setKana(item.getKana());
        this.setStartDate(item.getStartDate());
        this.setEndDate(item.getEndDate());
        this.setDisUseDate(item.getDisUseDate());
        this.setClassCode(item.getClaimClassCode());
    }

    public ClaimItem(String code, String number) {
        this();
        this.setCode(code);
        this.setNumber(number);
    }

    @Override
    public boolean search(DolphinQuery query) {
        if (this.name != null && this.name.indexOf(query.what("keyword")) != -1) {
            return true;
        }
        return this.memo != null && this.memo.indexOf(query.what("keyword")) != -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String val) {
        this.code = val;
    }

    public String getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(String val) {
        this.codeSystem = val;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String val) {
        this.classCode = val;
    }

    public String getClassCodeSystem() {
        return this.classCodeSystem;
    }

    public void setClassCodeSystem(String val) {
        this.classCodeSystem = val;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String val) {
        this.number = StringTool.zenkakuNumToHankaku(val);
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String val) {
        this.unit = val;
    }

    public String getNumberCode() {
        if (this.number == null) {
            return "";
        }
        return this.numberCode;
    }

    public void setNumberCode(String val) {
        this.numberCode = val;
    }

    public String getNumberCodeSystem() {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        return line.get(0);
    }

    public void setNumberCodeSystem(String val) {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        line.set(0, val);
        this.numberCodeSystem = line.toCombinedString();
    }

    public String getMemo() {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        return line.get(1);
    }

    public void setMemo(String val) {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        line.set(1, val);
        this.memo = line.toCombinedString();
    }

    public String getYkzKbn() {
        return this.ykzkbn;
    }

    public void setYkzKbn(String ykzkbn) {
        this.ykzkbn = ykzkbn;
    }

    public List<String> getSstKijunCdSet() {
        return this.sstKijunCdSet;
    }

    public void setSstKijunCdSet(List<String> val) {
        this.sstKijunCdSet = val;
    }

    public float getSuryo1() {
        return this.suryo1;
    }

    public void setSuryo1(float val) {
        this.suryo1 = val;
    }

    public float getSuryo2() {
        return this.suryo2;
    }

    public void setSuryo2(float val) {
        this.suryo2 = val;
    }

    public String getNameReplaceToHankakuSpace() {
        return this.name.replaceAll("\u3000", " ");
    }

    public boolean isComplexCommentCode() {
        boolean rtn = this.code.startsWith("84") || this.code.startsWith("0084");
        return rtn;
    }

    public String getKana() {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        return line.get(2);
    }

    public void setKana(String kana) {
        if (kana != null) {
            CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
            line.limit(4);
            line.set(2, kana);
            this.numberCodeSystem = line.toCombinedString();
        }
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getDisUseDate() {
        CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
        line.limit(4);
        return line.get(3);
    }

    public void setDisUseDate(String disUseDate) {
        if (disUseDate != null) {
            CombinedStringParser line = new CombinedStringParser('|', this.numberCodeSystem);
            line.limit(4);
            line.set(3, disUseDate);
            this.numberCodeSystem = line.toCombinedString();
        }
    }

    protected boolean isExpired() {
        return DateExpire.expire(this.startDate, this.endDate);
    }

    public boolean isUpdateAvailable(List<MedicineEntry> resultSet, GenericAdapter adapter) {
        try {
            return adapter.onResult(this.getCode(), resultSet);
        }
        catch (Exception ex) {
            adapter.onError(ex);
            return false;
        }
    }

    public void serialize(Writer result) throws IOException {
        result.append("<ClaimItem name='" + this.name + "code='" + this.code + "' codeSystem='" + this.codeSystem + "' classCode='" + this.classCode + "' classCodeSystem='" + this.classCodeSystem + "' number='" + this.number + "' unit='" + this.unit + "' numberCode='" + this.numberCode + "' numberCodeSystem='" + this.numberCodeSystem + "' memo='" + this.memo + "ykzkbn='" + this.ykzkbn + "suryo1='" + Float.toString(this.suryo1) + "suryo2='" + Float.toString(this.suryo2) + "'>\n");
        for (String item : this.sstKijunCdSet) {
            result.append("<item>");
            result.append(item);
            result.append("</item>");
        }
        result.append("</ClaimItem>");
    }
}

