/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.SinryoCode;

public class CommentHelper {
    private final int NAME_LENGTH = 40;

    public boolean confirm(MasterItem item) {
        String original_name;
        String modified_name = original_name = item.getName();
        while (true) {
            if (SinryoCode.isNoFormatComment(item.getCode())) {
                if ((modified_name = this.editNoFormatComment(modified_name)) != null && !modified_name.trim().isEmpty()) {
                    if (this.isValidName(modified_name)) {
                        item.setName(modified_name.trim());
                        return true;
                    }
                    this.showErrorMessage();
                    continue;
                }
                return false;
            }
            if (SinryoCode.isPrefixComment(item.getCode())) {
                if ((modified_name = this.editPrefixComment(modified_name)) != null && !modified_name.trim().isEmpty()) {
                    if (this.isValidName(modified_name)) {
                        item.setName(modified_name.trim());
                        return true;
                    }
                    this.showErrorMessage();
                    continue;
                }
                return false;
            }
            if (SinryoCode.isComplexComment(item.getCode())) break;
        }
        String msg = this.makeSstKijunCdFormat(item.getSstKijunCdSet(), "0");
        String value = this.editComplexComment(modified_name + "\n\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\uff1a" + msg, item.getNumber() != null ? item.getNumber() : "");
        if (value != null && !value.trim().isEmpty()) {
            item.setNumber(value.trim());
            return true;
        }
        return false;
    }

    private String editNoFormatComment(String s) {
        return JOptionPane.showInputDialog(null, "\u7de8\u96c6\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u5148\u982d\u304b\u3089\uff14\uff10\u6587\u5b57\u307e\u3067\u304c\u5165\u529b\u3055\u308c\u307e\u3059\u3002)\n", s);
    }

    private String editPrefixComment(String s) {
        String sep = "\uff1a";
        String format = s.replaceFirst(sep + ".*", "") + sep;
        String value = s.replaceFirst(".*" + sep, "");
        StringBuffer sb = new StringBuffer();
        sb.append("\u7de8\u96c6\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u6587\u4f75\u305b\u3066\u6700\u592740\u6587\u5b57\uff09\n");
        sb.append(format);
        String rtn = JOptionPane.showInputDialog(null, sb.toString(), value);
        return rtn != null ? format + rtn : null;
    }

    private String editComplexComment(String format, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u7de8\u96c6\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
        sb.append(format);
        String rtn = JOptionPane.showInputDialog(null, sb.toString(), value != null ? value : "");
        return rtn == null ? value : rtn;
    }

    private String makeSstKijunCdFormat(List ary, String s) {
        String num;
        String pos;
        Iterator it = ary.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext() && (pos = (String)it.next()) != null && !pos.trim().isEmpty() && !pos.trim().equals("0") && it.hasNext() && (num = (String)it.next()) != null && !num.trim().isEmpty() && !pos.trim().equals("0")) {
            int numi = Integer.parseInt(num);
            if (!sb.toString().trim().isEmpty()) {
                sb.append("-");
            }
            for (int i = 0; i < numi; ++i) {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    private boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.trim().isEmpty()) {
            return false;
        }
        return 40 >= name.length();
    }

    private void showErrorMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(40));
        sb.append("\u6587\u5b57\u4ee5\u4e0b\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        JOptionPane.showMessageDialog(null, sb.toString());
    }
}

