/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import open.dolphin.dto.AppointSpec;
import open.dolphin.dto.DiagnosisSearchSpec;
import open.dolphin.dto.DocumentSearchSpec;
import open.dolphin.dto.ImageSearchSpec;
import open.dolphin.dto.ModuleSearchSpec;
import open.dolphin.dto.ObservationSearchSpec;
import open.dolphin.exception.CanNotDeleteException;
import open.dolphin.infomodel.AllergyModel;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.ObservationModel;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.infomodel.PhysicalModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IKarteService;
import org.hibernate.HibernateException;

public class RemoteKarteService
extends DolphinService
implements IKarteService {
    @Override
    public KarteBean getKarte(long patientPk, Date fromDate) {
        KarteBean karte;
        block12: {
            this.roleAllowed("user");
            karte = null;
            try {
                List memo;
                List documents;
                List latestVisits;
                PhysicalModel physical;
                ArrayList<PhysicalModel> physicals;
                this.startTransaction();
                karte = (KarteBean)this.getSession().createQuery("from KarteBean where patient_id = :patientPk").setParameter("patientPk", (Object)patientPk).uniqueResult();
                long karteId = karte.getId();
                List observations = this.getSession().createQuery("from ObservationModel where karte_id=:karteId and observation='Allergy'").setParameter("karteId", (Object)karteId).list();
                if (observations != null && observations.size() > 0) {
                    ArrayList<AllergyModel> allergies = new ArrayList<AllergyModel>(observations.size());
                    for (ObservationModel observation : observations) {
                        AllergyModel allergy = new AllergyModel();
                        allergy.setObservationId(observation.getId());
                        allergy.setFactor(observation.getPhenomenon());
                        allergy.setSeverity(observation.getCategoryValue());
                        allergy.setIdentifiedDate(observation.confirmDateAsString());
                        allergies.add(allergy);
                    }
                    karte.addEntryCollection("allergy", allergies);
                }
                if ((observations = this.getSession().createQuery("from ObservationModel where karte_id=:karteId and observation='PhysicalExam' and phenomenon='bodyHeight'").setParameter("karteId", (Object)karteId).list()) != null && observations.size() > 0) {
                    physicals = new ArrayList<PhysicalModel>(observations.size());
                    for (ObservationModel observation : observations) {
                        physical = new PhysicalModel();
                        physical.setHeightId(observation.getId());
                        physical.setHeight(observation.getValue());
                        physical.setIdentifiedDate(observation.confirmDateAsString());
                        physical.setMemo(ModelUtils.getDateAsString(observation.getRecorded()));
                        physicals.add(physical);
                    }
                    karte.addEntryCollection("height", physicals);
                }
                if ((observations = this.getSession().createQuery("from ObservationModel where karte_id=:karteId and observation='PhysicalExam' and phenomenon='bodyWeight'").setParameter("karteId", (Object)karteId).list()) != null && observations.size() > 0) {
                    physicals = new ArrayList(observations.size());
                    for (ObservationModel observation : observations) {
                        physical = new PhysicalModel();
                        physical.setWeightId(observation.getId());
                        physical.setWeight(observation.getValue());
                        physical.setIdentifiedDate(observation.confirmDateAsString());
                        physical.setMemo(ModelUtils.getDateAsString(observation.getRecorded()));
                        physicals.add(physical);
                    }
                    karte.addEntryCollection("weight", physicals);
                }
                if ((latestVisits = this.getSession().createQuery("select pvtDate from PatientVisitModel where patient_id = :patientPk and pvtDate >= :fromDate").setParameter("patientPk", (Object)patientPk).setParameter("fromDate", (Object)ModelUtils.getDateAsString(fromDate)).list()) != null && latestVisits.size() > 0) {
                    karte.addEntryCollection("visit", latestVisits);
                }
                if ((documents = this.getSession().createQuery("from DocumentModel where karte_id = :karteId and started >= :fromDate and (status='F' or status='T')").setParameter("karteId", (Object)karteId).setParameter("fromDate", (Object)fromDate).list()) != null && documents.size() > 0) {
                    ArrayList<DocInfoModel> docInfos = new ArrayList<DocInfoModel>();
                    for (DocumentModel document : documents) {
                        document.toDetuch();
                        docInfos.add(document.getDocInfo());
                    }
                    karte.addEntryCollection("docInfo", docInfos);
                }
                if ((memo = this.getSession().createQuery("from PatientMemoModel where karte_id = :karteId").setParameter("karteId", (Object)karteId).list()) != null && memo.size() > 0) {
                    karte.addEntryCollection("patientMemo", memo);
                }
                this.endTransaction();
            }
            catch (Exception e) {
                if (!this.getSession().getTransaction().isActive()) break block12;
                this.getSession().getTransaction().rollback();
            }
        }
        return karte;
    }

    @Override
    public List<DocInfoModel> getDocumentList(DocumentSearchSpec spec) {
        this.roleAllowed("user");
        List documents = null;
        StringBuilder optionalQuery = new StringBuilder();
        String condition = "";
        if (spec.isIncludeModifid()) {
            optionalQuery.append("status='M'");
        }
        if (spec.isIncludeUnsend()) {
            if (optionalQuery.length() != 0) {
                optionalQuery.append(" or ");
            }
            optionalQuery.append("status='T'");
        }
        if (spec.isIncludeSend()) {
            if (optionalQuery.length() != 0) {
                optionalQuery.append(" or ");
            }
            optionalQuery.append("status='F'");
        }
        if (optionalQuery.length() != 0) {
            condition = "and (" + optionalQuery.toString() + ")";
        }
        ArrayList<DocInfoModel> result = new ArrayList<DocInfoModel>();
        try {
            this.startTransaction();
            documents = this.getSession().createQuery("from DocumentModel where karte_id = :karteId and started >= :fromDate " + condition).setParameter("karteId", (Object)spec.getKarteId()).setParameter("fromDate", (Object)spec.getFromDate()).list();
            this.endTransaction();
        }
        catch (HibernateException e) {
            if (this.getSession().getTransaction().isActive()) {
                this.getSession().getTransaction().rollback();
            }
            return result;
        }
        for (DocumentModel document : documents) {
            document.toDetuch();
            result.add(document.getDocInfo());
        }
        return result;
    }

    @Override
    public List<DocumentModel> getDocuments(List<Long> ids) {
        ArrayList<DocumentModel> ret;
        block3: {
            this.roleAllowed("user");
            ret = new ArrayList<DocumentModel>();
            try {
                this.startTransaction();
                for (Long id : ids) {
                    DocumentModel document = (DocumentModel)this.getSession().createQuery("from DocumentModel where id = :id").setParameter("id", (Object)id).uniqueResult();
                    ret.add(document);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public long putDocument(DocumentModel document) {
        long id;
        block5: {
            this.roleAllowed("user");
            this.getSession().clear();
            id = document.getId();
            try {
                this.startTransaction();
                this.getSession().persist((Object)document);
                long parentPk = document.getDocInfo().getParentPk();
                if (parentPk != 0L) {
                    Date ended = document.getConfirmed();
                    DocumentModel old = (DocumentModel)this.getSession().createQuery("from DocumentModel where id = :id").setParameter("id", (Object)parentPk).uniqueResult();
                    old.setEnded(ended);
                    for (ModuleModel moduleModel : old.getModules()) {
                        moduleModel.setEnded(ended);
                    }
                    for (SchemaModel schemaModel : old.getSchemas()) {
                        schemaModel.setEnded(ended);
                    }
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block5;
                this.getSession().getTransaction().rollback();
            }
        }
        return id;
    }

    @Override
    public int deleteDocument(long pk) {
        block6: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                Date ended = new Date();
                DocumentModel delete = (DocumentModel)this.getSession().createQuery("from DocumentModel where id = :id").setParameter("id", (Object)pk).uniqueResult();
                if (delete.getLinkId() != 0L) {
                    this.endTransaction();
                    throw new CanNotDeleteException("\u4ed6\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u53c2\u7167\u3057\u3066\u3044\u308b\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                }
                int refs = ((Number)this.getSession().createQuery("select count(*) from DocumentModel where linkid=:pk").setParameter("pk", (Object)pk).uniqueResult()).intValue();
                if (refs > 0) {
                    this.endTransaction();
                    throw new CanNotDeleteException("\u4ed6\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u304b\u3089\u53c2\u7167\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                }
                delete.setStatus("D");
                delete.setEnded(ended);
                for (ModuleModel moduleModel : delete.getModules()) {
                    moduleModel.setStatus("D");
                    moduleModel.setEnded(ended);
                }
                for (SchemaModel schemaModel : delete.getSchemas()) {
                    schemaModel.setStatus("D");
                    schemaModel.setEnded(ended);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block6;
                this.getSession().getTransaction().rollback();
            }
        }
        return 1;
    }

    @Override
    public int updateTitle(long pk, String title) {
        this.roleAllowed("user");
        this.startTransaction();
        DocumentModel update = (DocumentModel)this.getSession().createQuery("from DocumentModel where id = :id").setParameter("id", (Object)pk).uniqueResult();
        update.getDocInfo().setTitle(title);
        this.endTransaction();
        return 1;
    }

    @Override
    public List<List> getModules(ModuleSearchSpec spec) {
        ArrayList<List> ret;
        block3: {
            this.roleAllowed("user");
            Date[] fromDate = spec.getFromDate();
            Date[] toDate = spec.getToDate();
            int len = fromDate.length;
            ret = new ArrayList<List>(len);
            try {
                this.startTransaction();
                for (int i = 0; i < len; ++i) {
                    List modules = this.getSession().createQuery("from ModuleModel where karte_id = :karteId and entity = :entity and started between :fromDate and :toDate and status='F'").setParameter("karteId", (Object)spec.getKarteId()).setParameter("entity", (Object)spec.getEntity()).setParameter("fromDate", (Object)fromDate[i]).setParameter("toDate", (Object)toDate[i]).list();
                    ret.add(modules);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public List<ModuleModel> getAllModule(ModuleSearchSpec spec) {
        List modules;
        block2: {
            this.roleAllowed("user");
            modules = null;
            try {
                this.startTransaction();
                modules = this.getSession().createQuery("from ModuleModel m where m.karte.id = :karteId and m.moduleInfo.entity = :entity and m.status='F'").setParameter("karteId", (Object)spec.getKarteId()).setParameter("entity", (Object)spec.getEntity()).list();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return modules;
    }

    @Override
    public List<List> getImages(ImageSearchSpec spec) {
        ArrayList<List> ret;
        block3: {
            this.roleAllowed("user");
            Date[] fromDate = spec.getFromDate();
            Date[] toDate = spec.getToDate();
            int len = fromDate.length;
            ret = new ArrayList<List>(len);
            try {
                this.startTransaction();
                for (int i = 0; i < len; ++i) {
                    List modules = this.getSession().createQuery("from SchemaModel i where i.karte.id = :karteId and i.started between :fromDate and :toDate and i.status='F'").setParameter("karteId", (Object)spec.getKarteId()).setParameter("fromDate", (Object)fromDate[i]).setParameter("toDate", (Object)toDate[i]).list();
                    ret.add(modules);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public SchemaModel getImage(long id) {
        SchemaModel image;
        block2: {
            this.roleAllowed("user");
            image = null;
            try {
                this.startTransaction();
                image = (SchemaModel)this.getSession().createQuery("from SchemaModel where id = :id").setParameter("id", (Object)id).uniqueResult();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return image;
    }

    @Override
    public List<RegisteredDiagnosisModel> getDiagnosis(DiagnosisSearchSpec spec) {
        List result;
        block2: {
            this.roleAllowed("user");
            result = null;
            try {
                this.startTransaction();
                result = spec.getFromDate() != null ? this.getSession().createQuery("from RegisteredDiagnosisModel r where r.karte.id = :karteId and r.started >= :fromDate").setParameter("karteId", (Object)spec.getKarteId()).setParameter("fromDate", (Object)spec.getFromDate()).list() : this.getSession().createQuery("from RegisteredDiagnosisModel r where r.karte.id = :karteId").setParameter("karteId", (Object)spec.getKarteId()).list();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return result;
    }

    @Override
    public List<Long> addDiagnosis(List<RegisteredDiagnosisModel> addList) {
        ArrayList<Long> ret;
        block3: {
            this.roleAllowed("user");
            ret = new ArrayList<Long>(addList.size());
            try {
                this.startTransaction();
                for (RegisteredDiagnosisModel bean : addList) {
                    this.getSession().persist((Object)bean);
                    ret.add(new Long(bean.getId()));
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public int updateDiagnosis(List<RegisteredDiagnosisModel> updateList) {
        int cnt;
        block3: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                for (RegisteredDiagnosisModel bean : updateList) {
                    this.getSession().merge((Object)bean);
                    ++cnt;
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public int removeDiagnosis(List<Long> removeList) {
        int cnt;
        block3: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                for (Long id : removeList) {
                    RegisteredDiagnosisModel bean = (RegisteredDiagnosisModel)this.getSession().createQuery("from RegisteredDiagnosisModel where id = :id").setParameter("id", (Object)id).uniqueResult();
                    this.getSession().delete((Object)bean);
                    ++cnt;
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public List<ObservationModel> getObservations(ObservationSearchSpec spec) {
        List ret;
        block5: {
            this.roleAllowed("user");
            ret = null;
            try {
                this.startTransaction();
                String observation = spec.getObservation();
                String phenomenon = spec.getPhenomenon();
                Date firstConfirmed = spec.getFirstConfirmed();
                if (observation != null) {
                    ret = firstConfirmed != null ? this.getSession().createQuery("from ObservationModel o where o.karte.id=:karteId and o.observation=:observation and o.started >= :firstConfirmed").setParameter("karteId", (Object)spec.getKarteId()).setParameter("observation", (Object)observation).setParameter("firstConfirmed", (Object)firstConfirmed).list() : this.getSession().createQuery("from ObservationModel o where o.karte.id=:karteId and o.observation=:observation").setParameter("karteId", (Object)spec.getKarteId()).setParameter("observation", (Object)observation).list();
                } else if (phenomenon != null) {
                    ret = firstConfirmed != null ? this.getSession().createQuery("from ObservationModel o where o.karte.id=:karteId and o.phenomenon=:phenomenon and o.started >= :firstConfirmed").setParameter("karteId", (Object)spec.getKarteId()).setParameter("phenomenon", (Object)phenomenon).setParameter("firstConfirmed", (Object)firstConfirmed).list() : this.getSession().createQuery("from ObservationModel o where o.karte.id=:karteId and o.phenomenon=:phenomenon").setParameter("karteId", (Object)spec.getKarteId()).setParameter("phenomenon", (Object)phenomenon).list();
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block5;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public List<Long> addObservations(List<ObservationModel> observations) {
        this.roleAllowed("user");
        if (observations != null && observations.size() > 0) {
            ArrayList<Long> ret;
            block4: {
                ret = new ArrayList<Long>(observations.size());
                try {
                    this.startTransaction();
                    for (ObservationModel model : observations) {
                        this.getSession().persist((Object)model);
                        ret.add(new Long(model.getId()));
                    }
                    this.endTransaction();
                }
                catch (HibernateException e) {
                    if (!this.getSession().getTransaction().isActive()) break block4;
                    this.getSession().getTransaction().rollback();
                }
            }
            return ret;
        }
        return null;
    }

    @Override
    public int updateObservations(List<ObservationModel> observations) {
        this.roleAllowed("user");
        if (observations != null && observations.size() > 0) {
            int cnt;
            block4: {
                cnt = 0;
                try {
                    this.startTransaction();
                    for (ObservationModel model : observations) {
                        this.getSession().merge((Object)model);
                        ++cnt;
                    }
                    this.endTransaction();
                }
                catch (HibernateException e) {
                    if (!this.getSession().getTransaction().isActive()) break block4;
                    this.getSession().getTransaction().rollback();
                }
            }
            return cnt;
        }
        return 0;
    }

    @Override
    public int removeObservations(List<Long> observations) {
        this.roleAllowed("user");
        if (observations != null && observations.size() > 0) {
            int cnt;
            block4: {
                cnt = 0;
                try {
                    this.startTransaction();
                    for (Long id : observations) {
                        ObservationModel model = (ObservationModel)this.getSession().createQuery("from ObservationModel where id = :id").setParameter("id", (Object)id).uniqueResult();
                        this.getSession().delete((Object)model);
                        ++cnt;
                    }
                    this.endTransaction();
                }
                catch (HibernateException e) {
                    if (!this.getSession().getTransaction().isActive()) break block4;
                    this.getSession().getTransaction().rollback();
                }
            }
            return cnt;
        }
        return 0;
    }

    @Override
    public int updatePatientMemo(PatientMemoModel memo) {
        int cnt;
        block4: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                if (memo.getId() == 0L) {
                    this.getSession().persist((Object)memo);
                } else {
                    this.getSession().merge((Object)memo);
                }
                ++cnt;
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block4;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public int putAppointments(AppointSpec spec) {
        int cnt;
        block8: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                Collection added = spec.getAdded();
                Collection updated = spec.getUpdared();
                Collection removed = spec.getRemoved();
                AppointmentModel bean2 = null;
                if (added != null && added.size() > 0) {
                    for (AppointmentModel bean2 : added) {
                        this.getSession().persist((Object)bean2);
                        ++cnt;
                    }
                }
                if (updated != null && updated.size() > 0) {
                    for (AppointmentModel bean2 : updated) {
                        this.getSession().merge((Object)bean2);
                        ++cnt;
                    }
                }
                if (removed != null && removed.size() > 0) {
                    for (AppointmentModel bean2 : removed) {
                        AppointmentModel target = (AppointmentModel)this.getSession().createQuery("from AppointmentModel where id = :id").setParameter("id", (Object)bean2.getId()).uniqueResult();
                        this.getSession().delete((Object)target);
                        ++cnt;
                    }
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block8;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public List<List> getAppointmentList(ModuleSearchSpec spec) {
        ArrayList<List> ret;
        block3: {
            this.roleAllowed("user");
            Date[] fromDate = spec.getFromDate();
            Date[] toDate = spec.getToDate();
            int len = fromDate.length;
            ret = new ArrayList<List>(len);
            try {
                this.startTransaction();
                for (int i = 0; i < len; ++i) {
                    List c = this.getSession().createQuery("from AppointmentModel a where a.karte.id = :karteId and a.date between :fromDate and :toDate").setParameter("karteId", (Object)spec.getKarteId()).setParameter("fromDate", (Object)fromDate[i]).setParameter("toDate", (Object)toDate[i]).list();
                    ret.add(c);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public long saveOrUpdateLetter(LetterModel model) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().saveOrUpdate((Object)model);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return model.getId();
    }

    @Override
    public List<LetterModel> getLetterList(long karteId, String docType) {
        List letters;
        block5: {
            this.roleAllowed("user");
            letters = null;
            try {
                this.startTransaction();
                if (docType.equals("TOUTOU")) {
                    letters = this.getSession().createQuery("from TouTouLetter f where f.karte.id = :karteId").setParameter("karteId", (Object)karteId).list();
                } else if (docType.equals("TOUTOU_REPLY")) {
                    letters = this.getSession().createQuery("from TouTouReply f where f.karte.id = :karteId").setParameter("karteId", (Object)karteId).list();
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block5;
                this.getSession().getTransaction().rollback();
            }
        }
        return letters;
    }

    @Override
    public List<LetterModel> getRecentLetterModels(String docType) {
        List letters;
        block5: {
            this.roleAllowed("user");
            letters = null;
            try {
                this.startTransaction();
                int limit = 30;
                if (docType.equals("TOUTOU")) {
                    Object result = null;
                    letters = this.getSession().createQuery("from TouTouLetter order by recorded desc").setMaxResults(30).list();
                } else if (docType.equals("TOUTOU_REPLY")) {
                    letters = this.getSession().createQuery("from TouTouReply order by recorded desc").setMaxResults(30).list();
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block5;
                this.getSession().getTransaction().rollback();
            }
        }
        return letters;
    }

    @Override
    public List<LetterModel> getRecentLetterModels(long karteId, String docType) {
        List letters;
        block5: {
            this.roleAllowed("user");
            letters = null;
            try {
                this.startTransaction();
                int limit = 30;
                if (docType.equals("TOUTOU")) {
                    letters = this.getSession().createQuery("from TouTouLetter f where f.karte.id = :karteId order by recorded desc").setParameter("karteId", (Object)karteId).setMaxResults(30).list();
                } else if (docType.equals("TOUTOU_REPLY")) {
                    letters = this.getSession().createQuery("from TouTouReply f where f.karte.id = :karteId order by recorded desc").setParameter("karteId", (Object)karteId).setMaxResults(30).list();
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block5;
                this.getSession().getTransaction().rollback();
            }
        }
        return letters;
    }

    @Override
    public LetterModel getLetter(long letterPk) {
        LetterModel letter;
        block2: {
            this.roleAllowed("user");
            letter = null;
            try {
                this.startTransaction();
                letter = (LetterModel)this.getSession().createQuery("from TouTouLetter t where t.id = :id").setParameter("id", (Object)letterPk).uniqueResult();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return letter;
    }

    @Override
    public LetterModel getLetterReply(long letterPk) {
        LetterModel letter;
        block2: {
            this.roleAllowed("user");
            letter = null;
            try {
                this.startTransaction();
                letter = (LetterModel)this.getSession().createQuery("from TouTouReply t where t.id = :id").setParameter("id", (Object)letterPk).uniqueResult();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return letter;
    }
}

