/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.stream.ImageInputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected final byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, new byte[8192]);
    }

    public BufferedOutputStream(OutputStream out, byte[] buf) {
        super(out);
        if (buf.length == 0) {
            throw new IllegalArgumentException("Buffer size == 0");
        }
        this.buf = buf;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void copyFrom(InputStream in) throws IOException {
        this.copyFrom(in, -1);
    }

    public synchronized void copyFrom(InputStream in, int len) throws IOException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (len < -1) {
            throw new IllegalArgumentException("len:" + len);
        }
        int read = 0;
        for (int toWrite = len == -1 ? Integer.MAX_VALUE : len; toWrite > 0; toWrite -= read) {
            read = in.read(this.buf, this.count, Math.min(toWrite, this.buf.length - this.count));
            if (read == -1) {
                if (len == -1) {
                    return;
                }
                throw new EOFException();
            }
            this.count += read;
            if (this.count < this.buf.length) continue;
            this.flushBuffer();
        }
    }

    public void copyFrom(ImageInputStream in) throws IOException {
        this.copyFrom(in, -1);
    }

    public synchronized void copyFrom(ImageInputStream in, int len) throws IOException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (len < -1) {
            throw new IllegalArgumentException("len:" + len);
        }
        int read = 0;
        for (int toWrite = len == -1 ? Integer.MAX_VALUE : len; toWrite > 0; toWrite -= read) {
            read = in.read(this.buf, this.count, Math.min(toWrite, this.buf.length - this.count));
            if (read == -1) {
                if (len == -1) {
                    return;
                }
                throw new EOFException();
            }
            this.count += read;
            if (this.count < this.buf.length) continue;
            this.flushBuffer();
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

