/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

public class DcmProtocol {
    public static final DcmProtocol DICOM = new DcmProtocol("dicom", null);
    public static final DcmProtocol DICOM_TLS = new DcmProtocol("dicom-tls", new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final DcmProtocol DICOM_TLS_3DES = new DcmProtocol("dicom-tls.3des", new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final DcmProtocol DICOM_TLS_AES = new DcmProtocol("dicom-tls.aes", new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final DcmProtocol DICOM_TLS_NODES = new DcmProtocol("dicom-tls.nodes", new String[]{"SSL_RSA_WITH_NULL_SHA"});
    private final String name;
    private final String[] cipherSuites;

    public static DcmProtocol valueOf(String protocol) {
        String lower = protocol.toLowerCase();
        if (lower.equals("dicom")) {
            return DICOM;
        }
        if (lower.equals("dicom-tls")) {
            return DICOM_TLS;
        }
        if (lower.equals("dicom-tls.3des")) {
            return DICOM_TLS_3DES;
        }
        if (lower.equals("dicom-tls.aes")) {
            return DICOM_TLS_AES;
        }
        if (lower.equals("dicom-tls.nodes")) {
            return DICOM_TLS_NODES;
        }
        throw new IllegalArgumentException("protocol:" + protocol);
    }

    private DcmProtocol(String name, String[] cipherSuites) {
        this.name = name;
        this.cipherSuites = cipherSuites;
    }

    public String toString() {
        return this.name;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public boolean isTLS() {
        return this.cipherSuites != null;
    }
}

