/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.hl7.HL7Exception;
import org.dcm4che.hl7.HL7Message;
import org.dcm4che.hl7.MSHSegment;
import org.dcm4cheri.hl7.HL7SegmentImpl;
import org.dcm4cheri.hl7.MSHSegmentImpl;

public class HL7MessageImpl
implements HL7Message {
    private final MSHSegmentImpl msh;
    private final ArrayList segs = new ArrayList(4);

    static int indexOfNextCRorLF(byte[] data, int start) {
        for (int i = start; i < data.length; ++i) {
            if (data[i] == 13 || data[i] == 10) {
                return i;
            }
            if (data[i] != 92) continue;
            ++i;
        }
        return data.length;
    }

    HL7MessageImpl(byte[] data) throws HL7Exception {
        int pos = HL7MessageImpl.indexOfNextCRorLF(data, 0);
        this.msh = new MSHSegmentImpl(data, 0, pos);
        while (++pos < data.length) {
            int nextPos = HL7MessageImpl.indexOfNextCRorLF(data, pos);
            int len = nextPos - pos;
            if (len > 0) {
                this.segs.add(new HL7SegmentImpl(data, pos, len));
            }
            pos = nextPos;
        }
    }

    public MSHSegment header() {
        return this.msh;
    }

    public List segments() {
        return Collections.unmodifiableList(this.segs);
    }

    public String toString() {
        return this.segs.toString();
    }

    StringBuffer toVerboseStringBuffer(StringBuffer sb) {
        sb.append(this.msh.getMessageType()).append('^').append(this.msh.getTriggerEvent()).append(" message\t// ").append(HL7SegmentImpl.getName(this.msh.getMessageType(), "????")).append(" - ").append(HL7SegmentImpl.getName(this.msh.getTriggerEvent(), "????"));
        sb.append("\n\t");
        this.msh.toVerboseStringBuffer(sb);
        Iterator it = this.segs.iterator();
        while (it.hasNext()) {
            sb.append("\n\t");
            ((HL7SegmentImpl)it.next()).toVerboseStringBuffer(sb);
        }
        return sb;
    }

    public String toVerboseString() {
        return this.toVerboseStringBuffer(new StringBuffer()).toString();
    }
}

