/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import [Ljava.lang.Number;;
import fr.apteryx.imageio.dicom.Constants;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DataSetReader;
import fr.apteryx.imageio.dicom.DicomColorSpace;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomReader;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.Normalizer;
import fr.apteryx.imageio.dicom.Operations;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ShortToUShortRenderedImage;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.Util;
import fr.apteryx.imageio.dicom.VOILUTColorModel;
import fr.apteryx.imageio.dicom.VOIWindowColorModel;
import fr.apteryx.imageio.dicom.VOIWindowColorModelFloat;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

final class DicomObject
implements Constants,
Serializable {
    String sopInstance;
    String sopClass;
    final DataSet ds;
    final TransferSyntax transferSyntax;
    TransferSyntax readTS;
    private static byte[] zero = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] version = new byte[]{0, 1};

    DicomObject(DataSet dataSet, String string, String string2, TransferSyntax transferSyntax) {
        this.ds = dataSet;
        this.sopClass = string;
        this.sopInstance = string2;
        this.transferSyntax = transferSyntax;
    }

    public String toString() {
        return "DICOM object (class " + this.sopClass + ", instance " + this.sopInstance + ")\n" + (this.ds == null ? "No dataset" : this.ds.toString());
    }

    DicomObject(ImageInputStream imageInputStream, DicomWarningListener dicomWarningListener, RawValues rawValues) throws IOException {
        this(DicomReader.readMeta(imageInputStream, dicomWarningListener), imageInputStream, dicomWarningListener, rawValues);
    }

    DicomObject(DataSet dataSet, ImageInputStream imageInputStream, DicomWarningListener dicomWarningListener, RawValues rawValues) throws IOException {
        Object object;
        if (dataSet != null) {
            object = dataSet.find(131074);
            if (object == null || ((DataElement)object).value == null) {
                dicomWarningListener.warning("ProtocoleViolation", "MediaStorageSOPClassUID has no value");
            } else {
                this.sopClass = (String)((DataElement)object).value;
            }
            object = dataSet.find(131075);
            if (object == null || ((DataElement)object).value == null) {
                dicomWarningListener.warning("ProtocoleViolation", "MediaStorageSOPInstanceUID has no value");
            } else {
                this.sopInstance = (String)((DataElement)object).value;
            }
            object = dataSet.find(131088);
            if (!(((DataElement)object).value instanceof String)) {
                throw new DicomException("ProtocoleViolation", "TransferSyntaxUID VR is not UI");
            }
            this.readTS = TransferSyntax.getInstance((String)((DataElement)object).value);
            DataSetReader dataSetReader = new DataSetReader(imageInputStream, this.readTS, dicomWarningListener, rawValues, false);
            this.ds = dataSetReader.readDataSet();
        } else {
            dicomWarningListener.warning("ProtocoleViolation", "Not a part 10 DICOM file, trying implicit little endian transfer syntax");
            object = new DataSetReader(imageInputStream, dicomWarningListener, rawValues, false);
            this.ds = ((DataSetReader)object).readDataSet();
            this.readTS = TransferSyntax.IMPLICIT_LITTLEENDIAN;
        }
        TransferSyntax transferSyntax = this.transferSyntax = rawValues == RawValues.NONE ? null : this.readTS;
        if (this.sopClass == null) {
            object = this.ds.find(524310);
            if (object == null) {
                throw new DicomException("ProtocoleViolation", "SOPClassUID not present");
            }
            if (((DataElement)object).value instanceof String) {
                this.sopClass = (String)((DataElement)object).value;
            } else if (((DataElement)object).value instanceof byte[]) {
                this.sopClass = new String((byte[])((DataElement)object).value);
            } else {
                throw new DicomException("ProtocoleViolation", "Invalid VR for SOPClassUID");
            }
        }
        if (this.sopInstance == null) {
            object = this.ds.find(524312);
            if (((DataElement)object).value instanceof String) {
                this.sopInstance = (String)((DataElement)object).value;
            } else if (((DataElement)object).value instanceof byte[]) {
                this.sopInstance = new String((byte[])((DataElement)object).value);
            } else {
                dicomWarningListener.warning("ProtocoleViolation", "SOPInstanceUID not present or wrong VR");
                this.sopInstance = "";
            }
        }
    }

    void write(ImageOutputStream imageOutputStream, TransferSyntax transferSyntax, DicomWriter dicomWriter) throws IOException {
        imageOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        for (int i = 128 / zero.length; i > 0; --i) {
            imageOutputStream.write(zero);
        }
        imageOutputStream.write(68);
        imageOutputStream.write(73);
        imageOutputStream.write(67);
        imageOutputStream.write(77);
        if (this.transferSyntax != null) {
            transferSyntax = this.transferSyntax;
        }
        DataSet dataSet = new DataSet();
        dataSet.add(131072, new Long(12 + (version.length + 1 & 0xFFFFFFFE) + 8 + (this.sopClass.length() + 1 & 0xFFFFFFFE) + 8 + (this.sopInstance.length() + 1 & 0xFFFFFFFE) + 8 + (transferSyntax.uid.length() + 1 & 0xFFFFFFFE) + 8 + ("1.2.826.0.1.3680043.2.228.0.2".length() + 1 & 0xFFFFFFFE)));
        dataSet.add(131073, version);
        dataSet.add(131074, this.sopClass);
        dataSet.add(131075, this.sopInstance);
        dataSet.add(131088, transferSyntax.uid);
        dataSet.add(131090, "1.2.826.0.1.3680043.2.228.0.2");
        dataSet.write(imageOutputStream, TransferSyntax.EXPLICIT_LITTLEENDIAN, false, dicomWriter, true);
        this.ds.write(imageOutputStream, transferSyntax, false, dicomWriter, false);
    }

    void reset() {
        this.ds.clear();
        this.sopInstance = null;
        this.sopClass = null;
    }

    synchronized void normalize(DicomWarningListener dicomWarningListener) throws DicomException {
        new Normalizer(dicomWarningListener).normalize(this);
        this.ds.add(528432, "EVALUATION OF THE DICOM IMAGE I/O PLUGIN");
    }

    void updateFromICM(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        int[] nArray = new int[]{n & 0xFFFF, 0, 16};
        short[] sArray = new short[n];
        short[] sArray2 = new short[n];
        short[] sArray3 = new short[n];
        for (int i = n - 1; i >= 0; --i) {
            sArray[i] = (short)(indexColorModel.getRed(i) << 8);
            sArray2[i] = (short)(indexColorModel.getGreen(i) << 8);
            sArray3[i] = (short)(indexColorModel.getBlue(i) << 8);
        }
        this.ds.add(2625793, nArray);
        this.ds.add(2625794, nArray);
        this.ds.add(2625795, nArray);
        this.ds.add(2626049, sArray);
        this.ds.add(2626050, sArray2);
        this.ds.add(2626051, sArray3);
    }

    static DataSet findMacro(int n, DataSet dataSet, DataSet dataSet2) {
        DataSet dataSet3;
        DataSet dataSet4 = dataSet3 = dataSet2 == null ? null : dataSet2.findDataSet(n);
        if (dataSet3 != null) {
            return dataSet3;
        }
        if (dataSet != null && (dataSet3 = dataSet.findDataSet(n)) != null) {
            return dataSet3;
        }
        return null;
    }

    TransferSyntax selectSuitableTS(TransferSyntax[] transferSyntaxArray) {
        for (int i = 0; i < transferSyntaxArray.length; ++i) {
            if (!this.suits(transferSyntaxArray[i])) continue;
            return transferSyntaxArray[i];
        }
        return null;
    }

    boolean suits(TransferSyntax transferSyntax) {
        if (transferSyntax.encapsulated) {
            if (transferSyntax == TransferSyntax.JPEG_BASELINE_1 ? this.ds.findInt(2621697) > 8 : transferSyntax == TransferSyntax.JPEG_EXTENDED_2_4 && this.ds.findInt(2621697) > 12) {
                return false;
            }
            Object object = this.ds.findValue(2145386512);
            if (object != null) {
                ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(Util.getColorModel(object), Util.getSampleModel(object));
                if (imageTypeSpecifier.getSampleModel().getDataType() == 2 && (transferSyntax == TransferSyntax.JPEG_BASELINE_1 || transferSyntax == TransferSyntax.JPEG_EXTENDED_2_4 || transferSyntax == TransferSyntax.JPEG_LOSSLESS_14SV1 || transferSyntax == TransferSyntax.JPEG_LS_LOSSLESS)) {
                    imageTypeSpecifier = new ImageTypeSpecifier(ShortToUShortRenderedImage.getCompatibleColorModel(imageTypeSpecifier.getColorModel()), Util.convertSampleModel(imageTypeSpecifier.getSampleModel(), 1));
                }
                return transferSyntax.getWriterSpi().canEncodeImage(imageTypeSpecifier);
            }
        }
        return true;
    }

    void updateFromTransferSyntax(TransferSyntax transferSyntax) throws DicomException {
        if (transferSyntax == TransferSyntax.JPEG_BASELINE_1 || transferSyntax == TransferSyntax.JPEG_EXTENDED_2_4 || transferSyntax == TransferSyntax.JPEG_LOSSLESS_14SV1 || transferSyntax == TransferSyntax.JPEG_LS_LOSSLESS) {
            Object object;
            if (this.ds.findInt(0x280002) == 3) {
                this.ds.add(2621444, "YBR_FULL_422");
                this.ds.add(2621446, 0);
            }
            if ((object = this.ds.findValue(2145386512)) instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    DicomObject.forceUnsigned((IIOImage)iterator.next());
                }
            } else if (object instanceof IIOImage) {
                DicomObject.forceUnsigned((IIOImage)object);
            }
        } else if (transferSyntax == TransferSyntax.JPEG2000 || transferSyntax == TransferSyntax.JPEG2000_LOSSLESS) {
            if (this.ds.findInt(0x280002) == 3) {
                this.ds.add(2621444, transferSyntax == TransferSyntax.JPEG2000 ? "YBR_ICT" : "YBR_RCT");
            }
            this.ds.add(2621446, 0);
        }
    }

    private static void forceUnsigned(IIOImage iIOImage) throws DicomException {
        if (iIOImage.hasRaster()) {
            Raster raster = iIOImage.getRaster();
            SampleModel sampleModel = raster.getSampleModel();
            if (sampleModel.getDataType() != 2) {
                return;
            }
            if ((raster = Util.convertRaster(raster, 1)) == null) {
                throw new DicomException("ApplicationError", "Cannot convert non standard sample models");
            }
            iIOImage.setRaster(raster);
        } else {
            RenderedImage renderedImage = iIOImage.getRenderedImage();
            if (renderedImage.getSampleModel().getDataType() != 2) {
                return;
            }
            iIOImage.setRenderedImage(new ShortToUShortRenderedImage(renderedImage));
        }
    }

    boolean applyLUT(ApplyLUTTarget applyLUTTarget, int n, DicomWarningListener dicomWarningListener) {
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        Object object3;
        SampleModel sampleModel;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object4 = applyLUTTarget.bi == null ? null : applyLUTTarget.bi.getRaster();
        ColorModel colorModel = applyLUTTarget.cm == null ? applyLUTTarget.bi.getColorModel() : applyLUTTarget.cm;
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel2 = sampleModel = applyLUTTarget.sm == null ? ((Raster)object4).getSampleModel() : applyLUTTarget.sm;
        if (sampleModel.getNumBands() > 1 || colorModel instanceof IndexColorModel) {
            return true;
        }
        DataSet dataSet = null;
        Object object5 = this.ds.findValue(1375769136);
        if (object5 instanceof Collection && ((Collection)object5).size() > n) {
            object3 = ((Collection)object5).iterator();
            for (int i = 0; i < n; ++i) {
                object3.next();
            }
            dataSet = (DataSet)object3.next();
        }
        object3 = this.ds.findDataSet(1375769129);
        DataSet dataSet2 = DicomObject.findMacro(2658629, (DataSet)object3, dataSet);
        DataSet dataSet3 = DicomObject.findMacro(2658610, (DataSet)object3, dataSet);
        if (dataSet2 == null) {
            dataSet2 = this.ds;
        }
        if (dataSet3 == null) {
            dataSet3 = this.ds;
        }
        switch (sampleModel.getTransferType()) {
            case 0: 
            case 1: {
                n4 = 0;
                n3 = (1 << sampleModel.getSampleSize(0) - 1) - 1;
                break;
            }
            default: {
                n4 = -(1 << sampleModel.getSampleSize(0) - 2);
                n3 = (1 << sampleModel.getSampleSize(0) - 2) - 1;
            }
        }
        if (this.ds.has(2621703) && (n2 = this.ds.findInt(2621703)) < n3) {
            n3 = n2;
        }
        if (this.ds.has(2621702) && (n2 = this.ds.findInt(2621702)) > n4) {
            n4 = n2;
        }
        n2 = n4;
        int n5 = n3;
        float f = n4;
        float f2 = n3;
        float f3 = dataSet2.findFloat(2625618);
        float f4 = dataSet2.findFloat(2625619);
        if (f4 == 0.0f) {
            f4 = 1.0f;
        }
        if (f4 != 1.0f || f3 != 0.0f) {
            if (f4 > 0.0f) {
                f = (float)n4 * f4 + f3;
                f2 = (float)n3 * f4 + f3;
            } else {
                f = (float)n3 * f4 + f3;
                f2 = (float)n4 * f4 + f3;
            }
            n2 = (int)f;
            n5 = (int)f2;
            int n6 = f4 != (float)((int)f4) || f3 != (float)((int)f3) ? 4 : (n2 >= 0 ? (n5 <= 255 ? 0 : (n5 <= 65535 ? 1 : 3)) : (n2 >= Short.MIN_VALUE && n5 <= Short.MAX_VALUE ? 2 : 3));
            sampleModel = new PixelInterleavedSampleModel(n6, sampleModel.getWidth(), sampleModel.getHeight(), 1, sampleModel.getWidth(), new int[]{0});
            if (object4 != null) {
                object2 = Raster.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), new Point(((Raster)object4).getMinX(), ((Raster)object4).getMinY()));
                Operations.rescale((Raster)object4, (WritableRaster)object2, f4, f3);
                object4 = object2;
                bl = true;
            }
        } else {
            DataSet dataSet4 = dataSet2.findDataSet(2633728);
            if (dataSet4 != null) {
                object2 = (Number[])dataSet4.findValue(2633730, Number;.class);
                if (object2 == null || ((Number[])object2).length != 3) {
                    if (dicomWarningListener != null) {
                        dicomWarningListener.warning("ProtocoleViolation", "LUT Descriptor has invalid value");
                    }
                } else {
                    int n7 = this.ds.findInt(2621699);
                    int n8 = n7 == 0 ? object2[1].shortValue() & 0xFFFF : object2[1].shortValue();
                    object = dataSet4.findValue(2633734);
                    if (object4 == null) {
                        sampleModel = new PixelInterleavedSampleModel(object instanceof byte[] ? 0 : 1, sampleModel.getWidth(), sampleModel.getHeight(), 1, sampleModel.getWidth(), new int[]{0});
                    } else {
                        object4 = Operations.lookup((Raster)object4, n8, object);
                        sampleModel = ((Raster)object4).getSampleModel();
                        bl = true;
                    }
                    n2 = 0;
                    f = 0;
                    n5 = object instanceof byte[] ? 255 : 65535;
                    f2 = n5;
                }
            }
        }
        String string = this.ds.findString(0x20500020);
        if (string != null) {
            colorSpace = DicomColorSpace.getInstanceFromPresentationLUTShape(string);
            bl3 = true;
        } else {
            ColorSpace colorSpace2;
            object2 = this.ds.findDataSet(542113808);
            if (object2 != null && (colorSpace2 = DicomColorSpace.getInstanceFromPresentationLUTSequence((DataSet)object2)) != null) {
                colorSpace = colorSpace2;
                bl3 = true;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        object5 = dataSet3.findValue(2625616);
        if (object5 instanceof Number[]) {
            Number[] numberArray = (Number[])object5;
            if (numberArray.length > 0) {
                f5 = numberArray[0].floatValue();
            }
        } else if (object5 instanceof Number) {
            f5 = ((Number)object5).floatValue();
        }
        object5 = dataSet3.findValue(2625617);
        if (object5 instanceof Number[]) {
            Number[] numberArray = (Number[])object5;
            if (numberArray.length > 0) {
                f6 = numberArray[0].floatValue();
            }
        } else if (object5 instanceof Number) {
            f6 = ((Number)object5).floatValue();
        }
        if (f6 >= 1.0f) {
            colorModel = sampleModel.getTransferType() == 4 ? new VOIWindowColorModelFloat(f5, f6, colorSpace) : new VOIWindowColorModel(sampleModel.getTransferType(), sampleModel.getSampleSize(0), f5, f6, colorSpace);
            bl2 = true;
        } else {
            Number[] numberArray;
            Object object6 = dataSet3.findValue(2633744);
            object = null;
            if (object6 instanceof Collection) {
                object = (DataSet)((Collection)object6).iterator().next();
            } else if (object6 instanceof DataSet) {
                object = (DataSet)object6;
            }
            Number[] numberArray2 = object == null ? null : (numberArray = (Number[])((DataSet)object).findValue(2633730, Number;.class));
            if (numberArray != null && numberArray.length > 1 && sampleModel.getTransferType() != 4) {
                int n9 = ((DataSet)object).findInt(2621699);
                int n10 = n9 == 0 ? numberArray[1].shortValue() & 0xFFFF : numberArray[1].shortValue();
                Object object7 = ((DataSet)object).findValue(2633734);
                colorModel = new VOILUTColorModel(sampleModel.getTransferType(), numberArray[2].intValue(), n10, object7, colorSpace);
                bl2 = true;
            } else if (this.ds.has(2621703)) {
                colorModel = sampleModel.getTransferType() == 4 ? new VOIWindowColorModelFloat((f2 + f) / 2.0f, f2 - f, colorSpace) : new VOIWindowColorModel(sampleModel.getTransferType(), sampleModel.getSampleSize(0), (f2 + f) / 2.0f, f2 - f, colorSpace);
                bl2 = true;
            } else {
                if (object4 == null) {
                    return false;
                }
                if (sampleModel.getTransferType() == 4) {
                    float[] fArray = Operations.minmaxfloat((Raster)object4);
                    colorModel = new VOIWindowColorModelFloat((fArray[0] + fArray[1]) / 2.0f, fArray[1] - fArray[0], colorSpace);
                    bl2 = true;
                } else {
                    int[] nArray = Operations.minmax((Raster)object4);
                    n2 = nArray[0];
                    n5 = nArray[1];
                    int n11 = sampleModel.getDataType();
                    switch (n11) {
                        case 0: {
                            if (n2 == 0 && n5 == 255) {
                                if (!bl && !bl3) break;
                                colorModel = new ComponentColorModel(colorSpace, new int[]{8}, false, false, 1, n11);
                                bl2 = true;
                                break;
                            }
                            colorModel = new VOIWindowColorModel(0, 8, (n2 + n5) / 2, n5 - n2, colorSpace);
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            colorModel = new VOIWindowColorModel(2, 16, (n2 + n5) / 2, n5 - n2, colorSpace);
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            colorModel = new VOIWindowColorModel(1, 16, (n2 + n5) / 2, n5 - n2, colorSpace);
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            colorModel = new VOIWindowColorModel(3, 32, ((long)n2 + (long)n5) / 2L, n5 - n2, colorSpace);
                            bl2 = true;
                        }
                    }
                }
            }
        }
        applyLUTTarget.cm = colorModel;
        applyLUTTarget.sm = sampleModel;
        if (object4 != null && (bl2 || bl)) {
            applyLUTTarget.bi = new BufferedImage(colorModel, (WritableRaster)object4, false, null);
        }
        return true;
    }

    static class ApplyLUTTarget {
        BufferedImage bi;
        SampleModel sm;
        ColorModel cm;

        ApplyLUTTarget(BufferedImage bufferedImage) {
            this.bi = bufferedImage;
        }

        ApplyLUTTarget(SampleModel sampleModel, ColorModel colorModel) {
            this.cm = colorModel;
            this.sm = sampleModel;
        }
    }
}

