/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.IOException;

public class VerificationSCU {
    private final PeerAE peer;

    public VerificationSCU(PeerAE peerAE) {
        this.peer = peerAE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws DicomException, IOException {
        Association association = new Association(this.peer, new AbstractSyntax[]{new AbstractSyntax(1, "1.2.840.10008.1.1", TransferSyntax.DEFAULT_UIDLIST)});
        try {
            DataSet dataSet = new DataSet();
            int n = association.newMessageID();
            dataSet.add(2, "1.2.840.10008.1.1");
            dataSet.add(256, 48);
            dataSet.add(272, n);
            dataSet.add(2048, 257);
            dataSet.add(0, dataSet.getLength());
            association.sendMessage("1.2.840.10008.1.1", dataSet);
            ReceivedMessage receivedMessage = association.receiveMessage();
            if (receivedMessage == null) {
                throw new DicomException("ServiceError", "Association released by remote SCP");
            }
            DataSet dataSet2 = receivedMessage.command;
            if (dataSet2.findInt(288) != n || dataSet2.findInt(2304) != 0) {
                throw new DicomException("ProtocoleViolation", "Invalid echo response received");
            }
        }
        finally {
            association.release();
        }
    }
}

