/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.data.FilterDataset;
import org.dcm4cheri.data.SQElement;

class FilterSQElement
extends DcmElementImpl {
    private final SQElement sqElem;
    private final Dataset filter;
    private int totlen = -1;

    public FilterSQElement(SQElement sqElem, Dataset filter) {
        super(sqElem.tag());
        this.sqElem = sqElem;
        this.filter = filter;
    }

    public final int vr() {
        return 21329;
    }

    public final int vm(SpecificCharacterSet cs) {
        return this.sqElem.vm(cs);
    }

    public final int countItems() {
        return this.sqElem.countItems();
    }

    public Dataset getItem(int index) {
        return new FilterDataset.Selection(this.sqElem.getItem(index), this.filter);
    }

    public int calcLength(DcmEncodeParam param) {
        this.totlen = param.undefSeqLen ? 8 : 0;
        int n = this.countItems();
        for (int i = 0; i < n; ++i) {
            this.totlen += this.getItem(i).calcLength(param) + (param.undefItemLen ? 16 : 8);
        }
        return this.totlen;
    }

    public int length() {
        return this.totlen;
    }

    public String toString() {
        return "FilterSQElement[" + this.sqElem.toString() + "]";
    }
}

