/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.DateContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class DateContentImpl
extends NamedContentImpl
implements DateContent {
    private long time;

    DateContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, long time) {
        super(owner, obsDateTime, template, DateContentImpl.checkNotNull(name));
        this.time = time;
    }

    DateContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, Date date) {
        this(owner, obsDateTime, template, name, date.getTime());
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new DateContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.time);
    }

    public final void setName(Code newName) {
        this.name = DateContentImpl.checkNotNull(newName);
    }

    public String toString() {
        return this.prompt().append('(').append(this.getDate()).append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.DATE;
    }

    public final Date getDate() {
        return new java.sql.Date(this.time);
    }

    public final void setDate(Date date) {
        this.time = date.getTime();
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putDA(4235553, this.getDate());
    }
}

