/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.WaveformContent;
import org.dcm4cheri.srom.CompositeContentImpl;

class WaveformContentImpl
extends CompositeContentImpl
implements WaveformContent {
    private static final int[] NULL_CHANNELNUMBER = new int[0];
    protected int[] channelNumbers;

    WaveformContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, RefSOP refSOP, int[] channelNumbers) {
        super(owner, obsDateTime, template, name, refSOP);
        this.setChannelNumbers(channelNumbers);
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new WaveformContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.refSOP, this.channelNumbers);
    }

    public String toString() {
        StringBuffer sb = this.prompt().append(this.refSOP);
        for (int i = 0; i < this.channelNumbers.length; ++i) {
            sb.append(",[").append(this.channelNumbers[0]).append("]");
        }
        return sb.append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.WAVEFORM;
    }

    public final int[] getChannelNumbers() {
        return (int[])this.channelNumbers.clone();
    }

    public final void setChannelNumbers(int[] channelNumbers) {
        if (channelNumbers != null) {
            if ((channelNumbers.length & 1) != 0) {
                throw new IllegalArgumentException("L=" + channelNumbers.length);
            }
            this.channelNumbers = (int[])channelNumbers.clone();
        } else {
            this.channelNumbers = NULL_CHANNELNUMBER;
        }
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        if (this.channelNumbers.length != 0) {
            ds.get(528793).getItem().putUS(4235440, this.channelNumbers);
        }
    }
}

