/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.client.AbstractStampTreeBuilder;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.log.LogWriter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class StampTreeDirector {
    private final int TT_STAMP_INFO = 0;
    private final int TT_NODE = 1;
    private final int TT_ROOT = 2;
    private final int TT_STAMP_TREE = 3;
    private final int TT_STAMP_BOX = 4;
    private AbstractStampTreeBuilder builder;

    public StampTreeDirector(AbstractStampTreeBuilder builder) {
        this.builder = builder;
    }

    public List<StampTree> build(BufferedReader reader) {
        SAXBuilder docBuilder = new SAXBuilder();
        try {
            Document doc = docBuilder.build((Reader)reader);
            Element root = doc.getRootElement();
            this.builder.buildStart();
            this.parseChildren(root);
            this.builder.buildEnd();
        }
        catch (JDOMException e) {
            return new ArrayList<StampTree>();
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
        }
        return this.builder.getProduct();
    }

    public void parseChildren(Element current) {
        int eType = this.startElement(current.getName(), current);
        List children = current.getChildren();
        for (Element child : children) {
            this.parseChildren(child);
        }
        this.endElement(eType);
    }

    public int startElement(String eName, Element e) {
        if (eName.equals("stampInfo")) {
            this.builder.buildStampInfo(e.getAttributeValue("name"), e.getAttributeValue("role"), e.getAttributeValue("entity"), e.getAttributeValue("editable"), e.getAttributeValue("memo"), e.getAttributeValue("stampId"));
            return 0;
        }
        if (eName.equals("node")) {
            this.builder.buildNode(e.getAttributeValue("name"));
            return 1;
        }
        if (eName.equals("root")) {
            this.builder.buildRoot(e.getAttributeValue("name"), e.getAttributeValue("entity"));
            return 2;
        }
        if (eName.equals("stampTree")) {
            return 3;
        }
        if (eName.equals("stampBox")) {
            return 4;
        }
        return -1;
    }

    public void endElement(int eType) {
        switch (eType) {
            case 1: {
                this.builder.buildNodeEnd();
                break;
            }
            case 2: {
                this.builder.buildRootEnd();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
    }
}

