/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.DefaultStampTreeXmlBuilder;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.log.LogWriter;

public class StampTreeXmlDirector {
    private DefaultStampTreeXmlBuilder builder;

    public StampTreeXmlDirector(DefaultStampTreeXmlBuilder builder) {
        this.builder = builder;
    }

    public String build(List<StampTree> allTrees) {
        try {
            this.builder.buildStart();
            for (StampTree tree : allTrees) {
                this.lbuild(tree);
            }
            this.builder.buildEnd();
            return this.builder.getProduct();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
            return null;
        }
    }

    private void lbuild(StampTree tree) throws IOException {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> e = rootNode.preorderEnumeration();
        StampTreeNode node = (StampTreeNode)e.nextElement();
        this.builder.buildRoot(node);
        while (e.hasMoreElements()) {
            this.builder.buildNode((StampTreeNode)e.nextElement());
        }
        this.builder.buildRootEnd();
    }
}

