/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import open.dolphin.delegater.DelegaterErrorHandler;
import open.dolphin.delegater.error.CantFindPatentExcepion;
import open.dolphin.dto.LaboSearchSpec;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import open.dolphin.service.ILaboService;
import org.hibernate.HibernateException;

public abstract class LaboDelegater
extends DelegaterErrorHandler {
    protected abstract ILaboService getService() throws NamingException;

    public List<LaboModuleValue> getLaboModules(LaboSearchSpec spec) {
        try {
            long karteId = spec.getKarteId();
            ArrayList<LaboModuleValue> result = new ArrayList<LaboModuleValue>();
            long from = this.DateStringToLong(spec.getFromDate(), "yyyy-MM-dd");
            long to = this.DateStringToLong(spec.getToDate(), "yyyy-MM-dd");
            List<LaboModuleValue> modules = this.getService().getModulesFor(karteId);
            if (modules == null) {
                throw new Exception();
            }
            for (LaboModuleValue module : modules) {
                long sampleTime = this.DateStringToLong(module.getSampleTime(), "yyyy-MM-dd'T'HH:mm:ss");
                if (sampleTime <= from || sampleTime >= to) continue;
                result.add(module);
            }
            return result;
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    private long DateStringToLong(String dateString, String formatString) {
        long result = 0L;
        SimpleDateFormat deteformatter = new SimpleDateFormat(formatString);
        try {
            Date date = deteformatter.parse(dateString);
            result = date.getTime();
        }
        catch (ParseException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return result;
    }

    public PatientModel putLaboModule(LaboModuleValue value) throws CantFindPatentExcepion {
        try {
            return this.getService().putLaboModule(value);
        }
        catch (HibernateException ex) {
            this.dispatchError(this.getClass(), (Exception)((Object)ex), "");
            throw new CantFindPatentExcepion((Exception)((Object)ex));
        }
        catch (NamingException ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }

    public boolean isDuplicatedLaboTest(LaboModuleValue module) throws CantFindPatentExcepion {
        boolean result = false;
        KarteBean karte = this.getKarteFor(module.getPatientId());
        List<Object> modules = new ArrayList();
        try {
            modules = this.getService().getModulesFor(karte.getId());
        }
        catch (NamingException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        for (LaboModuleValue laboModuleValue : modules) {
            if (!laboModuleValue.getSampleTime().equals(module.getSampleTime()) || !laboModuleValue.getRegistTime().equals(module.getRegistTime()) || !laboModuleValue.getReportTime().equals(module.getReportTime())) continue;
            result = true;
            break;
        }
        return result;
    }

    public KarteBean getKarteFor(String patientId) throws CantFindPatentExcepion {
        try {
            return this.getService().getKarteFor(patientId);
        }
        catch (HibernateException ex) {
            this.dispatchError(this.getClass(), (Exception)((Object)ex), "");
            throw new CantFindPatentExcepion((Exception)((Object)ex));
        }
        catch (NamingException ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }
}

