/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dolphinpeer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import open.dolphin.client.ModelSender;
import open.dolphin.dolphinpeer.PeerBuilder;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;
import open.dolphin.utils.DebugDump;

public class PeerMessageReader {
    private static final int BUFFER_SIZE = 8192;
    private static final int EOT = 4;
    private static final int ACK = 6;
    private byte[] data = new byte[81920];
    private int length;
    private String encode;

    public PeerMessageReader(String encode) {
        this.encode = encode;
    }

    public void handle(SelectionKey key) throws ClosedChannelException, IOException {
        if (key.isReadable()) {
            try {
                this.read(key);
            }
            catch (SQLException ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
    }

    private void read(SelectionKey key) throws ClosedChannelException, IOException, SQLException {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.clear();
        int len = channel.read(buffer);
        if (len < 0) {
            channel.close();
            String pvtXml = new String(this.data, 0, this.length - 1, this.encode);
            DebugDump.dumpToFile("receivePeer.log", pvtXml);
            BufferedReader r = new BufferedReader(new StringReader(pvtXml));
            PeerBuilder builder = new PeerBuilder();
            builder.parse(r);
            PatientVisitModel model = builder.getProduct();
            ModelSender.getInstance().offer(model);
        } else {
            buffer.flip();
            buffer.get(this.data, this.length, len);
            this.length += len;
            if (buffer.get(len - 1) == 4) {
                ByteBuffer ackBuf2 = ByteBuffer.wrap(new byte[]{6});
                channel.write(ackBuf2);
            }
        }
    }
}

