/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.utils.StringTool;

public class PhysicalModel
extends InfoModel
implements Comparable {
    private static final long serialVersionUID = 5923780180643179995L;
    private long heightId;
    private long weightId;
    private String height;
    private String weight;
    private int bmi;
    private String identifiedDate;
    private String memo;

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getHeightId() {
        return this.heightId;
    }

    public void setHeightId(long heightId) {
        this.heightId = heightId;
    }

    public long getWeightId() {
        return this.weightId;
    }

    public void setWeightId(long weightId) {
        this.weightId = weightId;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String value) {
        this.height = StringTool.zenkakuNumToHankaku(value);
    }

    public String getIdentifiedDate() {
        return this.identifiedDate;
    }

    public String getIdentifiedFormatDate() {
        return ModelUtils.Convert("yyyy-MM-dd", "yyyy-MM-dd'('EEE')'", this.identifiedDate);
    }

    public void setIdentifiedDate(String value) {
        this.identifiedDate = value;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String value) {
        this.memo = value;
    }

    public void setWeight(String severity) {
        this.weight = StringTool.zenkakuNumToHankaku(severity);
    }

    public String getWeight() {
        return this.weight;
    }

    public String getBmi() {
        return this.calcBmi();
    }

    public String calcBmi() {
        if (this.height != null && this.weight != null) {
            float fw = new Float(this.weight).floatValue();
            float fh = new Float(this.height).floatValue() / 100.0f;
            float bmif = fw / (fh * fh);
            String bmiS = String.valueOf(bmif);
            int index = bmiS.indexOf(46);
            int len = bmiS.length();
            if (index > 0 && index + 2 < len) {
                bmiS = bmiS.substring(0, index + 2);
            }
            return bmiS;
        }
        return null;
    }

    public String getStandardWeight() {
        if (this.getHeight() == null) {
            return null;
        }
        try {
            float h = Float.parseFloat(this.getHeight());
            float stW = 22.0f * ((h /= 100.0f) * h);
            String stWS = String.valueOf(stW);
            int index = stWS.indexOf(46);
            if (index > 0) {
                stWS = stWS.substring(0, index + 2);
            }
            return stWS;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return null;
        }
    }

    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            String val1 = this.getIdentifiedDate();
            String val2 = ((PhysicalModel)other).getIdentifiedDate();
            return val1.compareTo(val2);
        }
        return 1;
    }
}

