/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.SinryoCode;
import open.dolphin.order.AbstractMedTableState;

public class MedHasItemState
extends AbstractMedTableState {
    public MedHasItemState(JTable medTable, JButton deleteBtn, JButton clearBtn, JTextField stampNameField, JLabel stateLabel) {
        super(medTable, deleteBtn, clearBtn, stampNameField, stateLabel);
    }

    @Override
    public void enter() {
        this.clearBtn.setEnabled(true);
        int index = this.medTable.getSelectedRow();
        Object obj = this.getTableModel().getObject(index);
        if (obj != null && !this.deleteBtn.isEnabled()) {
            this.deleteBtn.setEnabled(true);
        } else if (obj == null && this.deleteBtn.isEnabled()) {
            this.deleteBtn.setEnabled(false);
        }
        if (!this.hasMedicine()) {
            this.stateLabel.setText("\u533b\u85ac\u54c1\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (!this.hasAdmin()) {
            this.stateLabel.setText("\u7528\u6cd5\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (!this.isNumberOk()) {
            this.stateLabel.setText("\u6570\u91cf\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        this.stateLabel.setText("\u30ab\u30eb\u30c6\u306b\u5c55\u958b\u3067\u304d\u307e\u3059\u3002");
    }

    @Override
    public boolean isValidModel() {
        boolean result = false;
        result = this.isAllGaiyo() ? true : this.hasMedicine() && this.hasAdmin() && this.isNumberOk();
        return result;
    }

    private boolean isAllGaiyo() {
        List<Object> list = this.getTableModel().getObjectList();
        for (MasterItem masterItem : list) {
            String yakuzai_kubun = masterItem.getYkzKbn();
            if (yakuzai_kubun == null || yakuzai_kubun.equals("6")) continue;
            return false;
        }
        return true;
    }

    private boolean hasMedicine() {
        boolean result = false;
        List<Object> list = this.getTableModel().getObjectList();
        for (MasterItem masterItem : list) {
            if (masterItem.getClassCode() != 2) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasAdmin() {
        boolean adminOk = false;
        List<Object> list = this.getTableModel().getObjectList();
        for (MasterItem masterItem : list) {
            if (masterItem.getClassCode() != 3) continue;
            adminOk = true;
            break;
        }
        return adminOk;
    }

    private boolean isNumber(String test) {
        boolean result = true;
        try {
            Float num = Float.valueOf(Float.parseFloat(test));
            if (num.floatValue() < 0.0f || num.floatValue() == 0.0f) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private boolean isNumberOk() {
        boolean numberOk = true;
        List<Object> list = this.getTableModel().getObjectList();
        for (MasterItem masterItem : list) {
            if (SinryoCode.isComment(masterItem.getCode())) continue;
            if (masterItem.getClassCode() == 2 || masterItem.getClassCode() == 1) {
                if (this.isNumber(masterItem.getNumber().trim())) continue;
                numberOk = false;
                break;
            }
            if (masterItem.getClassCode() == 3) {
                if (this.isNumber(masterItem.getBundleNumber().trim())) continue;
                numberOk = false;
                break;
            }
            if (masterItem.getClassCode() != 0 || masterItem.getNumber() == null || masterItem.getNumber().equals("") || this.isNumber(masterItem.getNumber().trim())) continue;
            numberOk = false;
            break;
        }
        return numberOk;
    }
}

