/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import open.dolphin.log.LogWriter;

public class ObjectReflectTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = -8280948755982277457L;
    private String[] columnNames;
    private String[] methodNames;
    private Class[] columnClasses;
    private int startNumRows;
    private int columnCount;
    private List<T> objectList;

    public ObjectReflectTableModel(String[] columnNames, int startNumRows, String[] methodNames, Class[] columnClasses) {
        this.columnNames = columnNames;
        this.startNumRows = startNumRows;
        this.methodNames = methodNames;
        this.columnClasses = columnClasses;
        if (this.columnNames != null) {
            this.columnCount = columnNames.length;
        }
        this.objectList = new ArrayList<T>();
    }

    public ObjectReflectTableModel(int columnCount, int startNumRows, String[] methodNames, Class[] columnClasses) {
        this.columnCount = columnCount;
        this.startNumRows = startNumRows;
        this.methodNames = methodNames;
        this.columnClasses = columnClasses;
        this.objectList = new ArrayList<T>();
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames != null && index < this.columnNames.length ? this.columnNames[index] : null;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.objectList != null && this.objectList.size() > this.startNumRows ? this.objectList.size() : this.startNumRows;
    }

    public Class getColumnClass(int index) {
        return this.columnClasses != null && index < this.columnClasses.length ? this.columnClasses[index] : String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        T object = this.getObject(row);
        if (object != null && this.methodNames != null && col < this.methodNames.length) {
            try {
                Method targetMethod = object.getClass().getMethod(this.methodNames[col], null);
                return targetMethod.invoke(object, (Object[])null);
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
            }
        }
        return null;
    }

    public void setObjectList(List<T> objectList) {
        if (this.objectList != null) {
            this.objectList.clear();
            this.objectList = null;
        }
        this.objectList = objectList;
        this.fireTableDataChanged();
    }

    public String getMethodName(int index) {
        return this.methodNames[index];
    }

    public void setColumnName(String columnName, int col) {
        if (col >= 0 && col < this.columnNames.length) {
            this.columnNames[col] = columnName;
            this.fireTableStructureChanged();
        }
    }

    public void setMethodName(String methodName, int col) {
        if (col >= 0 && col < this.methodNames.length) {
            this.methodNames[col] = methodName;
            if (this.objectList != null) {
                this.fireTableDataChanged();
            }
        }
    }

    public List<T> getObjectList() {
        return this.objectList;
    }

    public void clear() {
        if (this.objectList != null) {
            this.objectList.clear();
            this.fireTableDataChanged();
        }
    }

    public T getObject(int index) {
        return this.objectList != null && index >= 0 && index < this.objectList.size() ? (T)this.objectList.get(index) : null;
    }

    public int getObjectCount() {
        return this.objectList != null ? this.objectList.size() : 0;
    }

    public void addRow(T add) {
        if (add != null) {
            if (this.objectList == null) {
                this.objectList = new ArrayList<T>();
            }
            int index = this.objectList.size();
            this.objectList.add(add);
            this.fireTableRowsInserted(index, index);
        }
    }

    public void addRow(int index, T add) {
        if (add != null && index > -1 && this.objectList != null && (this.objectList.isEmpty() && index == 0 || index < this.objectList.size())) {
            this.objectList.add(index, add);
            this.fireTableRowsInserted(index, index);
        }
    }

    public void insertRow(int index, T o) {
        this.addRow(index, o);
    }

    public void moveRow(int from, int to) {
        if (!this.isValidRow(from) || !this.isValidRow(to)) {
            return;
        }
        if (from == to) {
            return;
        }
        T o = this.objectList.remove(from);
        this.objectList.add(to, o);
        this.fireTableRowsUpdated(0, this.getObjectCount());
    }

    public void addRows(Collection c) {
        if (c != null) {
            if (this.objectList == null) {
                this.objectList = new ArrayList<T>();
            }
            int first = this.objectList.size();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.objectList.add(iter.next());
            }
            int last = this.objectList.size() - 1;
            this.fireTableRowsInserted(first, last);
        }
    }

    public void deleteRow(int index) {
        if (index > -1 && index < this.objectList.size()) {
            this.objectList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void deleteRow(T delete) {
        if (this.objectList != null && this.objectList.remove(delete)) {
            this.fireTableDataChanged();
        }
    }

    public void deleteRows(Collection c) {
        if (this.objectList != null && c != null) {
            this.objectList.removeAll(c);
            this.fireTableDataChanged();
        }
    }

    public int getIndex(Object o) {
        int index = 0;
        boolean found = false;
        if (this.objectList != null && o != null) {
            for (T obj : this.objectList) {
                if (obj == o) {
                    found = true;
                    break;
                }
                ++index;
            }
        }
        return found ? index : -1;
    }

    public boolean isValidRow(int row) {
        return this.objectList != null && row > -1 && row < this.objectList.size();
    }
}

