/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Attribute;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DataSetReaderWriter;
import fr.apteryx.imageio.dicom.DateRange;
import fr.apteryx.imageio.dicom.Day;
import fr.apteryx.imageio.dicom.DayRange;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.Dictionary;
import fr.apteryx.imageio.dicom.FloatingDate;
import fr.apteryx.imageio.dicom.PersonName;
import fr.apteryx.imageio.dicom.PixelData;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.StreamPart;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.Time;
import fr.apteryx.imageio.dicom.TimeRange;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.UnknownValue;
import fr.apteryx.imageio.dicom.ZipImageInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;

class DataSetReader
extends DataSetReaderWriter {
    private final DicomWarningListener wl;
    private final ImageInputStream is;
    private final TransferSyntax TS;
    private final RawValues rv;
    private long length = Long.MAX_VALUE;
    private final Stack dss = new Stack();
    private int ctag;
    private static final String NULL_DT = "00000000000000.000";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final byte[] b = new byte[2];
    private static Hashtable readers = new Hashtable();

    DataSetReader(ImageInputStream imageInputStream, DicomWarningListener dicomWarningListener, RawValues rawValues, boolean bl) {
        super(false);
        this.is = imageInputStream;
        this.TS = TransferSyntax.IMPLICIT_LITTLEENDIAN;
        this.wl = dicomWarningListener;
        this.rv = rawValues;
        try {
            this.length = imageInputStream.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.length < 0L) {
            this.length = Long.MAX_VALUE;
        }
    }

    DataSetReader(ImageInputStream imageInputStream, TransferSyntax transferSyntax, DicomWarningListener dicomWarningListener, RawValues rawValues, boolean bl) throws IOException {
        super(bl);
        this.is = transferSyntax == TransferSyntax.DEFLATED_EXPLICIT_LITTLEENDIAN ? new ZipImageInputStream(imageInputStream) : imageInputStream;
        this.TS = transferSyntax;
        this.wl = dicomWarningListener;
        this.rv = rawValues;
        try {
            this.length = imageInputStream.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.length < 0L) {
            this.length = Long.MAX_VALUE;
        }
    }

    private int read() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private int read(byte[] byArray) throws IOException {
        int n = this.is.read(byArray);
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private Day parseDA(String string) throws DicomException {
        int n = string.length();
        if (n != 8 && n != 10) {
            this.warning("ProtocoleViolation", "DA VR value length");
            return null;
        }
        try {
            if (n == 8) {
                return new Day(this.formats.dicom3DA.parse(string));
            }
            return new Day(this.formats.compatDA.parse(string));
        }
        catch (ParseException parseException) {
            this.warning("ProtocoleViolation", "DA VR value format");
            return null;
        }
    }

    private Double parseDS(String string) throws DicomException {
        int n = string.length();
        if (n > 16) {
            this.warning("ProtocoleViolation", "DS VR value length");
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.warning("ProtocoleViolation", "DS VR value format");
            return null;
        }
    }

    private Date parseDT(String string) throws DicomException {
        String string2;
        int n = string.indexOf(43);
        if (n < 0) {
            n = string.indexOf(45);
        }
        if (n < 0) {
            string2 = null;
        } else {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        int n2 = string.length();
        if (n2 > 21) {
            this.warning("ProtocoleViolation", "DT VR value length");
        }
        if (n2 > 18) {
            string = string.substring(0, 18);
        }
        string = string + NULL_DT.substring(string.length());
        try {
            return string2 == null ? new FloatingDate(this.formats.DTReadFloating.parse(string).getTime()) : this.formats.DTRead.parse(string + string2);
        }
        catch (ParseException parseException) {
            this.warning("ProtocoleViolation", "DT VR value format");
            return null;
        }
    }

    private Integer parseIS(String string) throws DicomException {
        int n = string.length();
        if (n > 12) {
            this.warning("ProtocoleViolation", "IS VR value length");
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.warning("ProtocoleViolation", "IS VR value format");
            return null;
        }
    }

    private PersonName parsePN(String string) throws DicomException {
        int n = string.length();
        if (n > 194) {
            this.warning("ProtocoleViolation", "PN VR value length");
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        PersonName personName = new PersonName();
        String[] stringArray = string.split("=");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\\^");
            String[] stringArray3 = new String[5];
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray3[j] = stringArray2[j];
            }
            if (stringArray2.length > 5) {
                this.warning("ProtocoleViolation", "Too many components in PN");
            }
            personName.add(stringArray3);
        }
        return personName;
    }

    private Time parseTM(String string) throws DicomException {
        int n = string.length();
        if (n > 16) {
            this.warning("ProtocoleViolation", "TM VR value length");
        }
        try {
            if (string.indexOf(58) < 0) {
                if (string.length() > 10) {
                    string = string.substring(0, 10);
                } else {
                    switch (string.length()) {
                        case 9: {
                            string = string + "0";
                            break;
                        }
                        case 8: {
                            string = string + "00";
                            break;
                        }
                        case 7: {
                            string = string + "000";
                            break;
                        }
                        case 6: {
                            string = string + ".000";
                            break;
                        }
                        case 4: {
                            string = string + "00.000";
                            break;
                        }
                        case 2: {
                            string = string + "0000.000";
                        }
                    }
                }
                return new Time(this.formats.dicom3TM.parse(string));
            }
            if (string.length() > 12) {
                string = string.substring(0, 12);
            } else {
                switch (string.length()) {
                    case 11: {
                        string = string + "0";
                        break;
                    }
                    case 10: {
                        string = string + "00";
                        break;
                    }
                    case 9: {
                        string = string + "000";
                        break;
                    }
                    case 8: {
                        string = string + ".000";
                        break;
                    }
                    case 6: {
                        string = string + "00.000";
                        break;
                    }
                    case 5: {
                        string = string + ":00.000";
                        break;
                    }
                    case 3: {
                        string = string + "00:00.000";
                        break;
                    }
                    case 2: {
                        string = string + ":00:00.000";
                    }
                }
            }
            return new Time(this.formats.compatTM.parse(string));
        }
        catch (ParseException parseException) {
            this.warning("ProtocoleViolation", "TM VR value format");
            return null;
        }
    }

    private static String[] vmSplit(String string) {
        if ((string = string.trim()).length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return string.split("\\\\");
    }

    private static Object checkStringVM(String string) {
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\\\");
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        return stringArray;
    }

    private String readString(long l, String string) throws IOException, DicomException {
        if (l == 0L) {
            return "";
        }
        byte[] byArray = new byte[(int)l];
        this.read(byArray);
        if (byArray[(int)l - 1] == 0) {
            --l;
        }
        try {
            return new String(byArray, 0, (int)l, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException("Unsupported", Tag.toString(this.ctag) + ": Character encoding");
        }
    }

    private String readString(long l) throws IOException, DicomException {
        return this.readString(l, this.enc);
    }

    String readVR() throws IOException {
        this.read(this.b);
        return new String(this.b, "ISO-8859-1");
    }

    private final int readTag() throws IOException {
        return Tag.create(this.is.readUnsignedShort(), this.is.readUnsignedShort());
    }

    private long skip(long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l && (l3 = this.is.skipBytes(l - l2)) != 0L; l2 += l3) {
        }
        return l2;
    }

    private static boolean canReadVR(String string) {
        return readers.get(string) != null;
    }

    private Object readValue(int n, String string) throws IOException, DicomException {
        long l;
        this.ctag = n;
        if (this.TS.explicitVR) {
            long l2;
            if (string.equals("OB") || string.equals("OW") || string.equals("OF") || string.equals("SQ") || string.equals("UN")) {
                this.skip(2L);
                l = (long)this.is.readInt() & 0xFFFFFFFFL;
                if (l != 0xFFFFFFFFL) {
                    if ((l & 1L) == 1L) {
                        this.warning("ProtocoleViolation", "OB, OW, OF, SQ or UN value length is not even");
                    }
                    if (l + this.getPos() > this.length) {
                        this.is.seek(this.getPos() - 6L);
                        l2 = (long)this.is.readShort() & 0xFFFFL;
                        if (l2 > 0L && l2 + this.getPos() <= this.length) {
                            this.warning("ProtocoleViolation", "OB, OW, OF, SQ or UN value length in reserved field");
                            l = l2;
                        }
                    }
                }
            } else if (string.equals("UT")) {
                this.skip(2L);
                l = (long)this.is.readInt() & 0xFFFFFFFFL;
                if ((l & 1L) == 1L) {
                    this.warning("ProtocoleViolation", "UT value length is not even");
                }
                if (l + this.getPos() > this.length) {
                    this.is.seek(this.getPos() - 6L);
                    l2 = (long)this.is.readShort() & 0xFFFFL;
                    if (l2 > 0L && l2 + this.getPos() <= this.length) {
                        this.warning("ProtocoleViolation", "UT value length in reserved field");
                        l = l2;
                    }
                }
            } else {
                l = (long)this.is.readShort() & 0xFFFFL;
                if ((l & 1L) == 1L) {
                    this.warning("ProtocoleViolation", "Value length is not even");
                }
            }
        } else {
            l = (long)this.is.readInt() & 0xFFFFFFFFL;
            if (l != 0xFFFFFFFFL && (l & 1L) == 1L) {
                this.warning("ProtocoleViolation", "Value length is not even");
            }
        }
        if (l != 0xFFFFFFFFL && l + this.getPos() > this.length) {
            throw new DicomException("ProtocoleViolation", "Value length larger that remaining bytes in stream");
        }
        if (!"SQ".equals(string) && (this.rv == RawValues.ALL || n == 2145386512 && this.rv == RawValues.PIXELDATA)) {
            if (n == 2145386512) {
                if (this.TS.encapsulated) {
                    int n2;
                    ArrayList<StreamPart> arrayList = new ArrayList<StreamPart>();
                    while ((n2 = this.readTag()) != -73507) {
                        if (n2 == -73728) {
                            int n3 = this.is.readInt();
                            arrayList.add(new StreamPart(this.is, this.is.getStreamPosition(), n3));
                            this.skip(n3);
                            continue;
                        }
                        throw new DicomException("ProtocoleViolation", Tag.toString(n) + ": Expected Sequence Delimitation Item");
                    }
                    this.skip(4L);
                    StreamPart[] streamPartArray = new StreamPart[arrayList.size()];
                    arrayList.toArray(streamPartArray);
                    return streamPartArray;
                }
                StreamPart streamPart = new StreamPart(this.is, this.is.getStreamPosition(), l);
                this.skip(l);
                return streamPart;
            }
            byte[] byArray = new byte[(int)l];
            this.read(byArray);
            return byArray;
        }
        if (string == null) {
            this.skip(l);
            return UnknownValue.instance;
        }
        if (string.equals("ox")) {
            if ((n & 0xFF00FFFF) == 1342185484) {
                DataSet dataSet = this.getCurrentDataSet();
                string = dataSet != null && dataSet.findInt(n & 0xFFFF0000 | 0x2002) == 0 ? "OW" : "OB";
            } else if ((n & 0xFF00FFFF) == 0x50003000) {
                DataSet dataSet = this.getCurrentDataSet();
                int n4 = dataSet == null ? 0 : dataSet.findInt(n & 0xFFFF0000 | 0x103);
                switch (n4) {
                    case 1: {
                        string = "SS";
                        break;
                    }
                    case 2: {
                        string = "FL";
                        break;
                    }
                    case 3: {
                        string = "FD";
                        break;
                    }
                    case 4: {
                        string = "SL";
                        break;
                    }
                    default: {
                        string = "US";
                        break;
                    }
                }
            } else {
                string = "OW";
            }
        } else if (string.equals("xs")) {
            DataSet dataSet = this.getCurrentDataSet();
            DataSet dataSet2 = this.getParentDataSet(1);
            string = dataSet != null && dataSet.findInt(2621699) == 0 || dataSet2 != null && dataSet2.findInt(2621699) == 0 ? "US" : "SS";
        }
        ValueReader valueReader = (ValueReader)readers.get(string);
        if (valueReader == null) {
            this.warning("ProtocoleViolation", Tag.toString(n) + ": Unknown VR '" + string + "'");
            this.skip(l);
            return UnknownValue.instance;
        }
        return valueReader.read(this, l, n);
    }

    private DataElement readDataElement() throws IOException, DicomException {
        Object object;
        Object object2;
        String string;
        int n = this.readTag();
        if (n == -73507 || n == -73715) {
            this.skip(4L);
            return new DataElement(n, null);
        }
        if (n == -73728) {
            long l = this.getPos() - 4L;
            DataSet dataSet = this.readDataSet((long)this.is.readInt() & 0xFFFFFFFFL);
            dataSet.offset = l;
            return new DataElement(n, dataSet);
        }
        if (this.TS.explicitVR) {
            string = this.readVR();
            object2 = Dictionary.getAttribute(n);
            if (object2 != null && ((Attribute)object2).VR.equals(string)) {
                object = object2;
            } else if (!(object2 == null || DataSetReader.canReadVR(string) || this.rv == RawValues.ALL || n == 2145386512 && this.rv == RawValues.PIXELDATA)) {
                this.warning("ProtocoleViolation", Tag.toString(n) + ": Unknown VR '" + string + "' fixed using dictionary");
                object = object2;
                string = ((Attribute)object2).VR;
            } else {
                object = new Attribute();
                ((Attribute)object).tag = n;
                ((Attribute)object).VR = string;
                ((Attribute)object).name = object2 == null ? null : ((Attribute)object2).name;
            }
        } else {
            object = Dictionary.getAttribute(n);
            if (object == null) {
                this.warning("Unsupported", "Unknown tag");
                string = null;
            } else {
                string = ((Attribute)object).VR;
            }
        }
        if (n == 524293 && this.rv != RawValues.ALL) {
            object2 = this.readValue(n, string);
            if (object2 != null) {
                String string2 = (String)CHARSETS_DICOM_JAVA.get(object2);
                if (string2 == null) {
                    this.warning("Unsupported", "Character set " + object2);
                } else {
                    this.enc = string2;
                }
            }
            return new DataElement(n, object2, (Attribute)object);
        }
        return new DataElement(n, this.readValue(n, string), (Attribute)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSet readDataSet(long l) throws IOException, DicomException {
        DataSet dataSet = new DataSet();
        this.dss.push(dataSet);
        try {
            this.initByteOrder();
            long l2 = this.getPos();
            while (this.getPos() - l2 < l) {
                DataElement dataElement = this.readDataElement();
                if (dataElement.tag == -73715) {
                    break;
                }
                dataSet.add(dataElement);
            }
        }
        finally {
            this.dss.pop();
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSet readDataSet() throws IOException, DicomException {
        DataSet dataSet = new DataSet();
        this.dss.push(dataSet);
        try {
            this.initByteOrder();
            try {
                while (true) {
                    DataElement dataElement = this.readDataElement();
                    dataSet.add(dataElement);
                }
            }
            catch (EOFException eOFException) {
                this.dss.pop();
            }
        }
        catch (Throwable throwable) {
            this.dss.pop();
            throw throwable;
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSet readGroup() throws IOException, DicomException {
        DataSet dataSet = new DataSet();
        this.dss.push(dataSet);
        try {
            long l;
            this.initByteOrder();
            int n = -1;
            long l2 = Long.MAX_VALUE;
            while ((l = this.getPos()) < l2) {
                DataElement dataElement = this.readDataElement();
                int n2 = Tag.getGroupNumber(dataElement.tag);
                if (n == -1) {
                    n = n2;
                } else if (n != n2) {
                    this.is.seek(l);
                    break;
                }
                if (Tag.getElementNumber(dataElement.tag) == 0) {
                    if (!(dataElement.value instanceof Long)) {
                        throw new DicomException("ProtocoleViolation", Tag.toString(dataElement.tag) + ": Group length VR is not UL");
                    }
                    l2 = this.getPos() + (Long)dataElement.value;
                }
                dataSet.add(dataElement);
            }
        }
        finally {
            this.dss.pop();
        }
        return dataSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("STREAM ");
        stringBuffer.append(this.TS);
        stringBuffer.append(" enc=");
        stringBuffer.append(this.enc);
        if (this.rv == RawValues.ALL) {
            stringBuffer.append(" raw values");
        } else if (this.rv == RawValues.PIXELDATA) {
            stringBuffer.append(" raw PixelData value");
        }
        return stringBuffer.toString();
    }

    private void initByteOrder() {
        this.is.setByteOrder(this.TS.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    private void warning(String string, String string2) {
        if (this.wl != null) {
            this.wl.warning(string, Tag.toString(this.ctag) + ": " + string2);
        }
    }

    private long getPos() throws IOException {
        return this.is.getStreamPosition();
    }

    private DataSet getCurrentDataSet() {
        return this.getParentDataSet(0);
    }

    private DataSet getParentDataSet(int n) {
        return this.dss.size() <= n ? null : (DataSet)this.dss.get(this.dss.size() - 1 - n);
    }

    static {
        readers.put("AE", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l, "ISO-8859-1").trim());
            }
        });
        readers.put("AS", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l, "ISO-8859-1"));
            }
        });
        readers.put("AT", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 3L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "AT VR value length");
                }
                if (l == 4L) {
                    return new Integer(dataSetReader.readTag());
                }
                Integer[] integerArray = new Integer[(int)(l /= 4L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    integerArray[n2] = new Integer(dataSetReader.readTag());
                    ++n2;
                }
                return integerArray;
            }
        });
        readers.put("CS", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l, "ISO-8859-1").trim());
            }
        });
        readers.put("DA", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = DataSetReader.vmSplit(dataSetReader.readString(l, "ISO-8859-1"));
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    String[] stringArray2;
                    if (dataSetReader.isFind && (stringArray2 = stringArray[0].split("-", 2)).length == 2) {
                        return new DayRange(stringArray2[0].length() == 0 ? null : dataSetReader.parseDA(stringArray2[0]), stringArray2[1].length() == 0 ? null : dataSetReader.parseDA(stringArray2[1]));
                    }
                    return dataSetReader.parseDA(stringArray[0]);
                }
                Day[] dayArray = new Day[n2];
                for (int i = 0; i < n2; ++i) {
                    dayArray[i] = dataSetReader.parseDA(stringArray[i]);
                }
                return dayArray;
            }
        });
        readers.put("DS", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = DataSetReader.vmSplit(dataSetReader.readString(l, "ISO-8859-1"));
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    return dataSetReader.parseDS(stringArray[0]);
                }
                Double[] doubleArray = new Double[n2];
                for (int i = 0; i < n2; ++i) {
                    doubleArray[i] = dataSetReader.parseDS(stringArray[i]);
                }
                return doubleArray;
            }
        });
        readers.put("DT", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = DataSetReader.vmSplit(dataSetReader.readString(l, "ISO-8859-1"));
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    String[] stringArray2;
                    if (dataSetReader.isFind && (stringArray2 = stringArray[0].split("-", 2)).length == 2) {
                        return new DateRange(stringArray2[0].length() == 0 ? null : dataSetReader.parseDT(stringArray2[0]), stringArray2[1].length() == 0 ? null : dataSetReader.parseDT(stringArray2[1]));
                    }
                    return dataSetReader.parseDT(stringArray[0]);
                }
                Date[] dateArray = new Date[n2];
                for (int i = 0; i < n2; ++i) {
                    dateArray[i] = dataSetReader.parseDT(stringArray[i]);
                }
                return dateArray;
            }
        });
        readers.put("FL", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 3L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "FL VR value length");
                    return null;
                }
                if (l == 4L) {
                    return new Float(Float.intBitsToFloat(dataSetReader.is.readInt()));
                }
                Float[] floatArray = new Float[(int)(l /= 4L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    floatArray[n2] = new Float(Float.intBitsToFloat(dataSetReader.is.readInt()));
                    ++n2;
                }
                return floatArray;
            }
        });
        readers.put("FD", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 7L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "FD VR value length");
                    return null;
                }
                if (l == 8L) {
                    return new Double(Double.longBitsToDouble(dataSetReader.is.readLong()));
                }
                Double[] doubleArray = new Double[(int)(l /= 8L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    doubleArray[n2] = new Double(Double.longBitsToDouble(dataSetReader.is.readLong()));
                    ++n2;
                }
                return doubleArray;
            }
        });
        readers.put("IS", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = DataSetReader.vmSplit(dataSetReader.readString(l, "ISO-8859-1"));
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    return dataSetReader.parseIS(stringArray[0]);
                }
                Integer[] integerArray = new Integer[n2];
                for (int i = 0; i < n2; ++i) {
                    integerArray[i] = dataSetReader.parseIS(stringArray[i]);
                }
                return integerArray;
            }
        });
        readers.put("LO", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l).trim());
            }
        });
        readers.put("LT", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if (l > 10240L) {
                    dataSetReader.warning("ProtocoleViolation", "LT VR value length");
                }
                return dataSetReader.readString(l).trim();
            }
        });
        readers.put("OB", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if (n == 2145386512) {
                    PixelData pixelData = new PixelData(dataSetReader.TS, dataSetReader.getPos(), l, "OB", dataSetReader.is);
                    if (l == 0xFFFFFFFFL) {
                        int n2;
                        while ((n2 = dataSetReader.readTag()) != -73507) {
                            if (n2 == -73728) {
                                l = (long)dataSetReader.is.readInt() & 0xFFFFFFFFL;
                                dataSetReader.skip(l);
                                continue;
                            }
                            throw new DicomException("ProtocoleViolation", Tag.toString(n) + ": Expected Item or Sequence Delimitation Item");
                        }
                        dataSetReader.skip(4L);
                    } else {
                        dataSetReader.skip(l);
                    }
                    return pixelData;
                }
                byte[] byArray = new byte[(int)l];
                dataSetReader.is.readFully(byArray);
                return byArray;
            }
        });
        readers.put("OF", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                float[] fArray = new float[(int)l / 4];
                dataSetReader.is.readFully(fArray, 0, fArray.length);
                return fArray;
            }
        });
        readers.put("OW", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if (n == 2145386512) {
                    PixelData pixelData = new PixelData(dataSetReader.TS, dataSetReader.getPos(), l, "OW", dataSetReader.is);
                    dataSetReader.skip(l);
                    return pixelData;
                }
                short[] sArray = new short[(int)l / 2];
                dataSetReader.is.readFully(sArray, 0, sArray.length);
                return sArray;
            }
        });
        readers.put("PN", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = dataSetReader.readString(l).split("\\\\");
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    return dataSetReader.parsePN(stringArray[0]);
                }
                PersonName[] personNameArray = new PersonName[n2];
                for (int i = 0; i < n2; ++i) {
                    personNameArray[i] = dataSetReader.parsePN(stringArray[i]);
                }
                return personNameArray;
            }
        });
        readers.put("SH", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l).trim());
            }
        });
        readers.put("SL", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 3L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "SL VR value length");
                    return null;
                }
                if (l == 4L) {
                    return new Integer(dataSetReader.is.readInt());
                }
                Integer[] integerArray = new Integer[(int)(l /= 4L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    integerArray[n2] = new Integer(dataSetReader.is.readInt());
                    ++n2;
                }
                return integerArray;
            }
        });
        readers.put("SQ", new ValueReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                Vector<Object> vector = new Vector<Object>();
                long l2 = dataSetReader.getPos();
                long l3 = dataSetReader.length;
                if (l < l3 - l2) {
                    dataSetReader.length = l2 + l;
                }
                try {
                    while (dataSetReader.getPos() - l2 < l) {
                        DataElement dataElement = dataSetReader.readDataElement();
                        if (dataElement.tag == -73507) {
                            break;
                        }
                        if (dataElement.tag != -73728) {
                            throw new DicomException("ProtocoleViolation", Tag.toString(n) + ": Expected Sequence Item");
                        }
                        vector.add(dataElement.value);
                    }
                }
                catch (DicomException dicomException) {
                    if (!"ProtocoleViolation".equals(dicomException.getMessage())) {
                        throw dicomException;
                    }
                    dataSetReader.warning("ProtocoleViolation", dicomException.getDetails() + " (trying to recover after sequence)");
                    dataSetReader.is.seek(l2 + l);
                }
                finally {
                    dataSetReader.length = l3;
                }
                return vector.size() > 0 ? vector : null;
            }
        });
        readers.put("SS", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 1L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "SS VR value length");
                    return null;
                }
                if (l == 2L) {
                    return new Short(dataSetReader.is.readShort());
                }
                Short[] shortArray = new Short[(int)(l /= 2L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    shortArray[n2] = new Short(dataSetReader.is.readShort());
                    ++n2;
                }
                return shortArray;
            }
        });
        readers.put("ST", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if (l > 1024L) {
                    dataSetReader.warning("ProtocoleViolation", "ST VR value length");
                }
                return dataSetReader.readString(l).trim();
            }
        });
        readers.put("TM", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                String[] stringArray = DataSetReader.vmSplit(dataSetReader.readString(l, "ISO-8859-1"));
                int n2 = stringArray.length;
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    String[] stringArray2;
                    if (dataSetReader.isFind && (stringArray2 = stringArray[0].split("-", 2)).length == 2) {
                        return new TimeRange(stringArray2[0].length() == 0 ? null : dataSetReader.parseTM(stringArray2[0]), stringArray2[1].length() == 0 ? null : dataSetReader.parseTM(stringArray2[1]));
                    }
                    return dataSetReader.parseTM(stringArray[0]);
                }
                Time[] timeArray = new Time[n2];
                for (int i = 0; i < n2; ++i) {
                    timeArray[i] = dataSetReader.parseTM(stringArray[i]);
                }
                return timeArray;
            }
        });
        readers.put("UI", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                return DataSetReader.checkStringVM(dataSetReader.readString(l, "ISO-8859-1").trim());
            }
        });
        readers.put("UL", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 3L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "UL VR value length");
                    return null;
                }
                if (l == 4L) {
                    return new Long((long)dataSetReader.is.readInt() & 0xFFFFFFFFL);
                }
                Long[] longArray = new Long[(int)(l /= 4L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    longArray[n2] = new Long((long)dataSetReader.is.readInt() & 0xFFFFFFFFL);
                    ++n2;
                }
                return longArray;
            }
        });
        readers.put("UN", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                byte[] byArray = new byte[(int)l];
                dataSetReader.read(byArray);
                return byArray;
            }
        });
        readers.put("US", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                if ((l & 1L) != 0L) {
                    dataSetReader.warning("ProtocoleViolation", "US VR value length");
                    return null;
                }
                if (l == 2L) {
                    return new Integer(dataSetReader.is.readShort() & 0xFFFF);
                }
                Integer[] integerArray = new Integer[(int)(l /= 2L)];
                int n2 = 0;
                while ((long)n2 < l) {
                    integerArray[n2] = new Integer(dataSetReader.is.readShort() & 0xFFFF);
                    ++n2;
                }
                return integerArray;
            }
        });
        readers.put("UT", new ValueReader(){

            public Object read(DataSetReader dataSetReader, long l, int n) throws IOException, DicomException {
                byte[] byArray = new byte[(int)l];
                dataSetReader.read(byArray);
                String string = new String(byArray, 0, (int)l, dataSetReader.enc);
                int n2 = string.length();
                while (string.charAt(n2 - 1) == ' ') {
                    --n2;
                }
                return n2 == string.length() ? string : string.substring(0, n2);
            }
        });
    }

    static interface ValueReader {
        public Object read(DataSetReader var1, long var2, int var4) throws DicomException, IOException;
    }
}

