/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CalendarCardPanel.java
 *
 * Created on 2010/03/08, 16:17:45
 */
package open.dolphin.client;

import java.awt.CardLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

import open.dolphin.project.GlobalSettings;
import open.dolphin.infomodel.SimpleDate;

/**
 *　カレンダー画面　MEMO:画面
 * @author
 */
public class CalendarCardPanel extends javax.swing.JPanel {

    /**
     *
     */
    public static final String PICKED_DATE = "pickedDate";
    private CardLayout cardLayout = new CardLayout();
    private int current;
    private int[] range;
    private Map<String, LiteCalendarPanel> calendars = new HashMap<String, LiteCalendarPanel>(12, 1.0f);
    private Map<String, Color> colorTable;
    private List<SimpleDate> markList;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener calendarListener;
    private Color titleFore = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_FORE);
    private Color titleBack = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_BACK);
    private SpinnerDateModel model;
    private JSpinner spinner;
    private JSpinner.DateEditor editor;

    /**
     * Creates new form CalendarCardPanel
     * @param colorTable 
     */
    public CalendarCardPanel(Map<String, Color> colorTable) {
        initComponents();

        this.colorTable = colorTable;
        calendarListener = new CalendarListener(this);
        current = 0;
        LiteCalendarPanel lc = new LiteCalendarPanel(current, false, this.colorTable);

        lc.addPropertyChangeListener(LiteCalendarPanel.SELECTED_DATE_PROP, calendarListener);
        // lc.setEventColorTable(colorTable);
        lc.setToday(SimpleDate.today());
        String name = String.valueOf(current);
        calendars.put(name, lc);

        cardPanel.setLayout(cardLayout);
        cardPanel.add(lc, name);

        titleLabel.setForeground(titleFore);
        titleLabel.setBackground(titleBack);

        updateTitle(lc, titleLabel);

        model = new SpinnerDateModel();
        spinner = new JSpinner(model);
        editor = new JSpinner.DateEditor(spinner, "yyyy.MM");
        spinner.setEditor(editor);

        cmdPanel.add(spinner);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cardPanel = new javax.swing.JPanel();
        cmdPanel = new javax.swing.JPanel();
        backBtn = new javax.swing.JButton();
        stopBtn = new javax.swing.JButton();
        forwardBtn = new javax.swing.JButton();
        titleLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        cardPanel.setName("cardPanel"); // NOI18N
        cardPanel.setLayout(new java.awt.CardLayout());
        add(cardPanel, java.awt.BorderLayout.CENTER);

        cmdPanel.setName("cmdPanel"); // NOI18N
        cmdPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 0, 5));

        backBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/open/dolphin/resources/images/pback_16.png"))); // NOI18N
        backBtn.setToolTipText("前月");
        backBtn.setName("backBtn"); // NOI18N
        backBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backBtnActionPerformed(evt);
            }
        });
        cmdPanel.add(backBtn);

        stopBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/open/dolphin/resources/images/splay_16.gif"))); // NOI18N
        stopBtn.setToolTipText("今月");
        stopBtn.setName("stopBtn"); // NOI18N
        stopBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopBtnActionPerformed(evt);
            }
        });
        cmdPanel.add(stopBtn);

        forwardBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/open/dolphin/resources/images/play_16.gif"))); // NOI18N
        forwardBtn.setToolTipText("次月");
        forwardBtn.setName("forwardBtn"); // NOI18N
        forwardBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                forwardBtnActionPerformed(evt);
            }
        });
        cmdPanel.add(forwardBtn);

        titleLabel.setFont(new java.awt.Font("Dialog", 0, 14));
        titleLabel.setText("2010年10月");
        titleLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        titleLabel.setName("titleLabel"); // NOI18N
        titleLabel.setOpaque(true);
        cmdPanel.add(titleLabel);

        add(cmdPanel, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    /**
     *
     * @param evt
     */
    private void backBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backBtnActionPerformed
        current -= 1;
        controlNavigation();
        showCalendar();
    }//GEN-LAST:event_backBtnActionPerformed
    /**
     *
     * @param evt
     */
    private void stopBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopBtnActionPerformed
        current = 0;
        controlNavigation();
        showCalendar();
    }//GEN-LAST:event_stopBtnActionPerformed
    /**
     *
     * @param evt
     */
    private void forwardBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_forwardBtnActionPerformed
        current += 1;
        controlNavigation();
        showCalendar();
    }//GEN-LAST:event_forwardBtnActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton backBtn;
    private javax.swing.JPanel cardPanel;
    private javax.swing.JPanel cmdPanel;
    private javax.swing.JButton forwardBtn;
    private javax.swing.JButton stopBtn;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @param lc
     * @param label　ラベル
     */
    private void updateTitle(LiteCalendarPanel lc, JLabel label) {
        label.setText(String.format("%04d年%02d月", lc.getYear(), lc.getMonth() + 1));
    }

    /**
     *
     * @param prop
     * @param l　プロパティチェンジリスナー
     */
    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    /**
     *
     * @param prop
     * @param l　プロパティチェンジリスナー
     */
    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     *
     * @param picked
     */
    public void notifyPickedDate(SimpleDate picked) {
        boundSupport.firePropertyChange(PICKED_DATE, null, picked);
    }

    /**
     *
     * @return　レンジ
     */
    public int[] getRange() {
        return range;
    }

    /**
     *
     * @param range　レンジ
     */
    public void setCalendarRange(int[] range) {
        this.range = range;
        controlNavigation();
    }

    /**
     *　
     * @param newMark　マーク
     */
    public void setMarkList(List<SimpleDate> newMark) {

        if (markList != newMark) {
            markList = newMark;
        }
        LiteCalendarPanel lc = calendars.get(String.valueOf(current));
        lc.getTableModel().setMarkDates(markList);
    }

    /**
     *　
     */
    private void controlNavigation() {
        if (range != null) {
            if (current == range[0]) {
                if (backBtn.isEnabled()) {
                    backBtn.setEnabled(false);
                }
                if (!forwardBtn.isEnabled()) {
                    forwardBtn.setEnabled(true);
                }
            } else if (current == range[1]) {
                if (forwardBtn.isEnabled()) {
                    forwardBtn.setEnabled(false);
                }
                if (!backBtn.isEnabled()) {
                    backBtn.setEnabled(true);
                }
            } else {
                if (!backBtn.isEnabled()) {
                    backBtn.setEnabled(true);
                }
                if (!forwardBtn.isEnabled()) {
                    forwardBtn.setEnabled(true);
                }
            }
        }
    }

    /**
     *　カレンダー表示
     */
    private void showCalendar() {

        String key = String.valueOf(current);
        LiteCalendarPanel lc = calendars.get(key);
        if (lc == null) {
            lc = new LiteCalendarPanel(current, false, colorTable);
            lc.addPropertyChangeListener(LiteCalendarPanel.SELECTED_DATE_PROP, calendarListener);
            //    lc.setEventColorTable(colorTable);
            lc.getTableModel().setMarkDates(markList);
            calendars.put(key, lc);
            cardPanel.add(lc, key);
        } else {
            lc.getTableModel().setMarkDates(markList);
        }
        updateTitle(lc, titleLabel);
        cardLayout.show(cardPanel, key);
    }

    /**
     *　　MEMO:リスナー
     */
    class CalendarListener implements PropertyChangeListener {

        private CalendarCardPanel owner;

        /**
         *
         * @param owner
         */
        public CalendarListener(CalendarCardPanel owner) {
            this.owner = owner;
        }

        /**
         *
         * @param e
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(LiteCalendarPanel.SELECTED_DATE_PROP)) {
                SimpleDate sd = (SimpleDate) e.getNewValue();
                owner.notifyPickedDate(sd);
            }
        }
    }
}
