package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * カルテコンテンツ MEMO:マッピング d_document
 * カルテ基本情報
 * スタンプ
 * シェーマ
 *
 * Serializable
 * DocumentModel generated by hbm2java
 */
public class DocumentModel extends KarteEntryBean {

    private DocInfoModel docInfo;//カルテ基本情報 MEMO:Refrection
    private Set<ModuleModel> modules;//スタンプ MEMO:Refrection
    private Set<SchemaModel> schemas;//シェーマ MEMO:Refrection

    /**
     *
     */
    public DocumentModel() {
        setDocInfo(new DocInfoModel());
        getDocInfo().setDocType(DOCTYPE_KARTE);
    }

    /**
     *
     */
    //  public void toDetuch() {
    //     if (docInfo != null) {
    //         docInfo.setDocPk(getId());
    //         docInfo.setParentPk(getLinkId());
    //          docInfo.setConfirmDate(getConfirmed());
    //        docInfo.setFirstConfirmDate(getStarted());
    //         docInfo.setStatus(getStatus());
    //    }
    //  }
    /**
     *
     */
    public void toPersist() {
        //  if (docInfo != null) {
        setLinkId(docInfo.getParentPk());
        setLinkRelation(docInfo.getParentIdRelation());
        setConfirmed(docInfo.getConfirmDate());
        setFirstConfirmed(docInfo.getFirstConfirmDate());
        setStatus(docInfo.getStatus());
        //    }
    }

    /**
     * カルテ基本情報のGetter
     * MEMO:Refrection
     * @return カルテ基本情報
     */
    public DocInfoModel getDocInfo() {
        return docInfo;
    }

    /**
     * カルテ基本情報のSetter
     * MEMO:Refrection
     * @param docInfo カルテ基本情報
     */
    public void setDocInfo(DocInfoModel docInfo) {
        this.docInfo = docInfo;
    }

    /**
     * シェーマのGetter
     * MEMO:Refrection
     * @return シェーマのセット
     */
    public Set<SchemaModel> getSchemas() {
        return schemas;
    }

    /**
     * シェーマのSetter
     * MEMO:Refrection
     * @param images シェーマのセット
     */
    public void setSchemas(Set<SchemaModel> images) {
        this.schemas = images;
    }

    /**
     * シェーマを追加
     * MEMO:Refrection
     * @param model
     */
    public void addSchema(SchemaModel model) {
        if (this.schemas == null) {
            this.schemas = new LinkedHashSet<SchemaModel>();
        }
        this.schemas.add(model);
    }

    /**
     * シェーマのClear
     * MEMO:Refrection
     */
    public void clearSchema() {
        if (schemas != null && schemas.size() > 0) {
            schemas.clear();
        }
    }

    /**
     * シェーマのGetter
     * MEMO:Refrection
     * @param index
     * @return シェーマ
     */
    public SchemaModel getSchema(int index) {
        if (schemas != null && schemas.size() > 0) {
            int cnt = 0;
            for (SchemaModel bean : schemas) {
                if (index == cnt) {
                    return bean;
                }
                cnt++;
            }
        }
        return null;
    }

    /**
     * スタンプのGetter
     * MEMO:Refrection
     * @return スタンプ
     */
    public Set<ModuleModel> getModules() {
        return modules;
    }

    /**
     * スタンプのSetter
     * MEMO:Refrection
     * @param modules スタンプ
     */
    public void setModules(Set<ModuleModel> modules) {
        this.modules = modules;
    }

    /**
     * スタンプの追加
     * MEMO:Refrection
     * @param addArray ModuleModel[]
     */
    public void addModule(ModuleModel[] addArray) {
        if (modules == null) {
            modules = new LinkedHashSet<ModuleModel>();
        }
        modules.addAll(Arrays.asList(addArray));
    }

    /**
     * スタンプの追加
     * MEMO:Refrection
     * @param addModule
     */
    public void addModule(ModuleModel addModule) {
        if (modules == null) {
            modules = new LinkedHashSet<ModuleModel>();
        }
        modules.add(addModule);
    }

    /**
     * スタンプのClear
     * MEMO:Refrection
     */
    public void clearModules() {
        if (modules != null && modules.size() > 0) {
            modules.clear();
        }
    }

    /**
     * スタンプのGetter
     * MEMO:Refrection
     * @param entityName
     * @return スタンプ
     */
    public ModuleModel getModule(String entityName) {
        if (modules != null) {
            ModuleModel ret = null;
            for (ModuleModel model : modules) {
                if (model.getModuleInfo() != null) {
                    if (model.getModuleInfo().getEntity().equals(entityName)) {
                        ret = model;
                        break;
                    }
                }
            }
            return ret;
        }
        return null;
    }

    /**
     * moduleInfoのGetter
     * @param entityName
     * @return moduleInfo
     */
    public IStampInfo[] getModuleInfo(String entityName) {
        Set<IStampInfo> result = new LinkedHashSet<IStampInfo>(2);
        if (modules != null) {
            for (ModuleModel model : modules) {
                if (model.getModuleInfo().getEntity().equals(entityName)) {
                    result.add(model.getModuleInfo());
                }
            }
            if (result.size() > 0) {
                return (IStampInfo[]) result.toArray(new ModuleInfoBean[result.size()]);
            }
        }
        return null;
    }

    /**
     * XMLにシリアライズ
     * @param result ライター
     * @throws IOException
     */
    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<DocumentModel>");
        result.append(System.getProperty("line.separator"));
        super.serialize(result);
        if (docInfo != null) {
            docInfo.serialize(result);
        }
        if (modules != null) {
            result.append("<Modules>");
            result.append(System.getProperty("line.separator"));
            for (ModuleModel module : modules) {
                module.serialize(result);
            }
            result.append("</Modules>");
            result.append(System.getProperty("line.separator"));
        }
        if (schemas != null) {
            result.append("<Schemas>");
            result.append(System.getProperty("line.separator"));
            for (SchemaModel _schema : schemas) {
                _schema.serialize(result);
            }
            result.append("</Schemas>");
            result.append(System.getProperty("line.separator"));
        }
        result.append("</DocumentModel>");
        result.append(System.getProperty("line.separator"));
    }
}
