/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MemoPanel.java
 *
 * Created on 2009/08/26, 15:50:12
 */
package open.dolphin.plugin.memopanel;

import java.awt.BorderLayout;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentListener;

import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.CompositeArea;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IChartDocument.TYPE;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter.ChartCommand;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.project.GlobalVariables;

/**
 * メモ　MEMO:画面
 * @author
 */
public class MemoPanel extends JPanel implements IChartDocument {

    /**
     *
     */
    public static final String TITLE = "メモ";
    private CompositeArea memoArea;
    private PatientMemoModel patientMemoModel;
    private IChart parent;
    private String title;

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnPanel = new javax.swing.JPanel();
        updateMemoBtn = new javax.swing.JButton();
        scrollPane = new javax.swing.JScrollPane();

        setMinimumSize(new java.awt.Dimension(0, 0));
        setPreferredSize(new java.awt.Dimension(242, 86));
        setLayout(new java.awt.BorderLayout());

        btnPanel.setName("btnPanel"); // NOI18N
        btnPanel.setLayout(new java.awt.BorderLayout());

        updateMemoBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/open/dolphin/resources/images/ref_16.gif"))); // NOI18N
        updateMemoBtn.setToolTipText("更新");
        updateMemoBtn.setEnabled(false);
        updateMemoBtn.setMargin(new java.awt.Insets(2, 2, 2, 2));
        updateMemoBtn.setName("updateMemoBtn"); // NOI18N
        updateMemoBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateMemoBtnActionPerformed(evt);
            }
        });
        btnPanel.add(updateMemoBtn, java.awt.BorderLayout.CENTER);

        add(btnPanel, java.awt.BorderLayout.EAST);

        scrollPane.setName("scrollPane"); // NOI18N
        add(scrollPane, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void updateMemoBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateMemoBtnActionPerformed
        updateMemo();
    }//GEN-LAST:event_updateMemoBtnActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel btnPanel;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JButton updateMemoBtn;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @return
     */
    @Override
    public TYPE getType() {
        return TYPE.Plugin;
        //      return TYPE.MemoPanel;
    }

    /**
     * MemoInspectorオブジェクトを生成する。
     * @param parent
     */
    public MemoPanel(IChart parent) {
        this.title = TITLE;
        this.parent = parent;
        initComponents();
        initCustomComponents();
        update();
    }

    /**
     * GUI コンポーネントを初期化する。
     */
    private void initCustomComponents() {
        memoArea = new CompositeArea(5, 10);
        memoArea.setLayout(new BorderLayout());
        memoArea.setLineWrap(true);
        memoArea.setMargin(new java.awt.Insets(3, 3, 2, 2));
        memoArea.addFocusListener(AutoKanjiListener.getInstance());
        memoArea.getDocument().addDocumentListener(new DocumentListener() {

            @Override
            public void insertUpdate(javax.swing.event.DocumentEvent e) {
                updateCheck();
            }

            @Override
            public void removeUpdate(javax.swing.event.DocumentEvent e) {
                updateCheck();
            }

            @Override
            public void changedUpdate(javax.swing.event.DocumentEvent e) {
            }
        });

        scrollPane.setViewportView(memoArea);
        //  add(memoArea, BorderLayout.CENTER);
    }

    /**
     * 患者メモを表示する。
     */
    private void update() {

        List list = getParentContext().getKarte().getEntryCollection("patientMemo");
        if (list != null && list.size() > 0) {
            patientMemoModel = (PatientMemoModel) list.get(0);
            memoArea.setText(patientMemoModel.getMemo());
            updateMemoBtn.setEnabled(false);
        }
    }

    /**
     * 患者メモを更新する。
     */
    public void updateMemo() {

        if (patientMemoModel == null) {
            patientMemoModel = new PatientMemoModel();
        }
        // 上書き更新
        Date confirmed = new Date();
        patientMemoModel.setKarte(getParentContext().getKarte());
        patientMemoModel.setCreator(GlobalVariables.getUserModel());
        patientMemoModel.setConfirmed(confirmed);
        patientMemoModel.setRecorded(confirmed);
        patientMemoModel.setStarted(confirmed);
        patientMemoModel.setStatus(IInfoModel.STATUS_FINAL);
        patientMemoModel.setMemo(memoArea.getText().trim());

        DBTask task = new DBTask<Void>(getParentContext()) {

            @Override
            protected Void doInBackground() throws Exception {
                RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                ddl.updatePatientMemo(patientMemoModel);
                return null;
            }

            @Override
            protected void succeeded(Void result) {
                updateMemoBtn.setEnabled(false);
            }
        };
        task.execute();
    }

    /**
     * メモ内容が変化した時、ボタンを活性化する。
     */
    private void updateCheck() {
        if (memoArea.getText().trim().length() <= 255) {
            updateMemoBtn.setEnabled(true);
        } else {
            updateMemoBtn.setEnabled(false);
        }
    }

    /**
     *
     * @return
     */
    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public String getTitle() {
        return title;
    }

    /**
     *
     * @return
     */
    @Override
    public IChart getParentContext() {
        return parent;
    }

    /**
     *
     */
    @Override
    public void start() {
    }

    /**
     *
     */
    @Override
    public void stop() {
    }

    /**
     *
     */
    @Override
    public void enter() {
    }

    /**
     *
     * @return
     */
    @Override
    public boolean prepare() {
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isDirty() {
        return false;
    }

    /**
     *
     * @param dirty
     */
    @Override
    public void setDirty(boolean dirty) {
    }

    /**
     *
     * @param command
     * @return
     */
    @Override
    public boolean dispatchChartCommand(ChartCommand command) {
        return false;
    }

    /**
     *
     * @return
     */
    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    /**
     *
     * @param o
     * @return
     */
    @Override
    public boolean update(Object o) {
        return true;
    }
}
