/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * PluginSettingPanel.java
 *
 * Created on 2010/09/27, 12:36:23
 */

package open.dolphin.plugin;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import javax.swing.JPanel;

import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.utils.Adapter;

/**
 *
 * @author
 */
public class RSBasePluginSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private final String NODE_NAME = "/open/dolphin/plugin/rsbase";

    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    /**
     *
     */
    protected State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private open.dolphin.plugin.IPlugin parent;
    private String address;
   private Adapter<Boolean, Boolean> adapter;

   /** Creates new form PluginSettingPanel
    * @param parent
    */
    public RSBasePluginSettingPanel(open.dolphin.plugin.IPlugin parent) {
        this.parent = parent;
        boundSupport = new PropertyChangeSupport(this);
        initComponents();
        
        setId("RsBasePlugin");
        setTitle("RSBaseプラグイン");
        setIcon("web_24.gif");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        addressField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        addressField.setName("addressField"); // NOI18N

        jLabel1.setText("RS_Baseが動作しているマシンのアドレス");
        jLabel1.setName("jLabel1"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(addressField, javax.swing.GroupLayout.PREFERRED_SIZE, 331, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(addressField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addContainerGap(271, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    /**
     *
     * @return
     */
    @Override
    public String getId() {
        return id;
    }

    /**
     *
     * @param id
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     *
     * @return
     */
    @Override
    public String getTitle() {
        return title;
    }

    /**
     *
     * @param title
     */
    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     *
     * @return
     */
    @Override
    public String getIcon() {
        return icon;
    }

    /**
     *
     * @param icon
     */
    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     *
     * @return
     */
    @Override
    public ProjectSettingDialog getContext() {
        return context;
    }

    /**
     *
     * @param context
     */
    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isLoginState() {
        return loginState;
    }

    /**
     *
     * @param login
     */
    @Override
    public void setLogInState(boolean login) {
        loginState = login;
    }

    /**
     *
     * @return
     */
    @Override
    public JPanel getPanel() {
        return this;
    }

    /**
     * 地域連携設定を開始する。
     */
    @Override
    public void start() {
        initCustomComponents();
        connect();
        Preferences prefs = Preferences.userRoot().node(NODE_NAME);
        addressField.setText(prefs.get("address", "localhost"));
    }

    private void initCustomComponents() {
    }

    private void connect() {
    }

    /**
     * 保存する。
     */
    @Override
    public void save() {
        Preferences prefs = Preferences.userRoot().node(NODE_NAME);
        address = addressField.getText();
        prefs.put("address", address);
    }

    /**
     * @param state The state to set.
     */
    @Override
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * @return Returns the state.
     */
    @Override
    public State getState() {
        return state;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField addressField;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @param adptr
     */
    public void onChenge(Adapter<Boolean, Boolean> adptr) {
      this.adapter = adapter;
    }
}
