/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection.web;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.injection.ConfigurableInjector;

public class InjectorHolder {
    private static final MetaDataKey<ConfigurableInjector> INJECTOR_KEY = new MetaDataKey<ConfigurableInjector>(){
        private static final long serialVersionUID = 1L;
    };

    public static ConfigurableInjector getInjector() {
        ConfigurableInjector injector = (ConfigurableInjector)Application.get().getMetaData(INJECTOR_KEY);
        if (injector == null) {
            throw new IllegalStateException("InjectorHolder has not been assigned an injector. Use InjectorHolder.setInjector() to assign an injector. In most cases this should be done once inside SpringWebApplication subclass's init() method.");
        }
        return injector;
    }

    public static void setInjector(ConfigurableInjector newInjector) {
        Application application = Application.get();
        application.setMetaData(INJECTOR_KEY, (Object)newInjector);
    }
}

