/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.Session;

public class PageReference
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final String pageMapName;
    private final int number;
    private final int version;

    PageReference(String pageMapName, int number, int version) {
        this.pageMapName = pageMapName;
        this.number = number;
        this.version = version;
    }

    public Page getPage() {
        return Session.get().getPage(this.pageMapName, Integer.toString(this.number), this.version);
    }

    public String getPageMapName() {
        return this.pageMapName;
    }

    public int getPageNumber() {
        return this.number;
    }

    public int getPageVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        result = 31 * result + (this.pageMapName == null ? 0 : this.pageMapName.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageReference other = (PageReference)obj;
        if (this.number != other.number) {
            return false;
        }
        if (this.pageMapName == null ? other.pageMapName != null : !this.pageMapName.equals(other.pageMapName)) {
            return false;
        }
        return this.version == other.version;
    }
}

