/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorsUtil {
    public static <M extends IBehavior> List<IBehavior> getBehaviors(Component component, Class<M> type) {
        List<IBehavior> behaviors = component.getBehaviors();
        if (behaviors == null) {
            return Collections.emptyList();
        }
        ArrayList<IBehavior> subset = new ArrayList<IBehavior>(behaviors.size());
        for (IBehavior behavior : behaviors) {
            if (behavior == null) continue;
            if (type == null) {
                subset.add(behavior);
                continue;
            }
            if (!type.isAssignableFrom(behavior.getClass())) continue;
            subset.add((IBehavior)type.cast(behavior));
        }
        return Collections.unmodifiableList(subset);
    }
}

