/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackMessagesModel
implements IModel<List<FeedbackMessage>> {
    private static final long serialVersionUID = 1L;
    private IFeedbackMessageFilter filter;
    private transient List<FeedbackMessage> messages;
    private Comparator<FeedbackMessage> sortingComparator;

    public FeedbackMessagesModel(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument [[page]] cannot be null");
        }
    }

    public FeedbackMessagesModel(Page page, IFeedbackMessageFilter filter) {
        this(page);
        this.setFilter(filter);
    }

    public final IFeedbackMessageFilter getFilter() {
        return this.filter;
    }

    public final Comparator<FeedbackMessage> getSortingComparator() {
        return this.sortingComparator;
    }

    @Override
    public final List<FeedbackMessage> getObject() {
        if (this.messages == null) {
            this.messages = Session.get().getFeedbackMessages().messages(this.filter);
            if (this.sortingComparator != null) {
                Collections.sort(this.messages, this.sortingComparator);
            }
            this.messages = this.processMessages(this.messages);
        }
        return this.messages;
    }

    public final FeedbackMessagesModel setFilter(IFeedbackMessageFilter filter) {
        this.filter = filter;
        return this;
    }

    public final FeedbackMessagesModel setSortingComparator(Comparator<FeedbackMessage> sortingComparator) {
        if (!(sortingComparator instanceof Serializable)) {
            throw new IllegalArgumentException("sortingComparator must be serializable");
        }
        this.sortingComparator = sortingComparator;
        return this;
    }

    protected List<FeedbackMessage> processMessages(List<FeedbackMessage> messages) {
        return messages;
    }

    @Override
    public void setObject(List<FeedbackMessage> object) {
    }

    @Override
    public void detach() {
        this.messages = null;
    }
}

