/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Response;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.HtmlHandler;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTag
extends MarkupElement {
    public static final String DEFAULT_WICKET_NAMESPACE = "wicket";
    private ComponentTag closes;
    protected final XmlTag xmlTag;
    private boolean autolink = false;
    private String id;
    private String path;
    private boolean modified = false;
    private transient boolean ignore = false;
    private boolean autoComponent = false;
    private WeakReference<Class<? extends Component>> markupClassRef = null;
    private boolean hasNoCloseTag = false;
    private List<IBehavior> behaviors;
    private Map<String, Object> userData;

    public ComponentTag(String name, XmlTag.Type type) {
        XmlTag tag = new XmlTag();
        tag.setName(name);
        tag.setType(type);
        this.xmlTag = tag;
    }

    public ComponentTag(XmlTag tag) {
        this.xmlTag = tag;
    }

    public ComponentTag(ComponentTag tag) {
        this(tag.getXmlTag());
        tag.copyPropertiesTo(this);
    }

    public final void addBehavior(IBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("Argument [behavior] cannot be null");
        }
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<IBehavior>();
        }
        this.behaviors.add(behavior);
    }

    public final boolean hasBehaviors() {
        return this.behaviors != null;
    }

    public final Iterator<? extends IBehavior> getBehaviors() {
        if (this.behaviors == null) {
            List lst = Collections.emptyList();
            return lst.iterator();
        }
        return Collections.unmodifiableCollection(this.behaviors).iterator();
    }

    @Override
    public final boolean closes(MarkupElement open) {
        if (open instanceof ComponentTag) {
            return this.closes == open || this.getXmlTag().closes(((ComponentTag)open).getXmlTag());
        }
        return false;
    }

    public final void enableAutolink(boolean autolink) {
        this.autolink = autolink;
    }

    public final IValueMap getAttributes() {
        return this.xmlTag.getAttributes();
    }

    public final String getAttribute(String name) {
        return this.xmlTag.getAttributes().getString(name);
    }

    public final String getId() {
        return this.id;
    }

    public final int getLength() {
        return this.xmlTag.getLength();
    }

    public final String getName() {
        return this.xmlTag.getName();
    }

    public final boolean getNameChanged() {
        return this.xmlTag.getNameChanged();
    }

    public final String getNamespace() {
        return this.xmlTag.getNamespace();
    }

    public final ComponentTag getOpenTag() {
        return this.closes;
    }

    public final int getPos() {
        return this.xmlTag.getPos();
    }

    public final CharSequence getString(String key) {
        return this.xmlTag.getString(key);
    }

    public final XmlTag.Type getType() {
        return this.xmlTag.getType();
    }

    public final boolean isAutolinkEnabled() {
        return this.autolink;
    }

    public final boolean isClose() {
        return this.xmlTag.isClose();
    }

    public final boolean isOpen() {
        return this.xmlTag.isOpen();
    }

    public final boolean isOpen(String id) {
        return this.xmlTag.isOpen() && this.id.equals(id);
    }

    public final boolean isOpenClose() {
        return this.xmlTag.isOpenClose();
    }

    public final boolean isOpenClose(String id) {
        return this.xmlTag.isOpenClose() && this.id.equals(id);
    }

    public boolean hasEqualTagName(ComponentTag tag) {
        return this.xmlTag.hasEqualTagName(tag.getXmlTag());
    }

    public final void makeImmutable() {
        this.xmlTag.makeImmutable();
    }

    public ComponentTag mutable() {
        if (this.xmlTag.isMutable()) {
            return this;
        }
        ComponentTag tag = new ComponentTag(this.xmlTag.mutable());
        this.copyPropertiesTo(tag);
        return tag;
    }

    void copyPropertiesTo(ComponentTag dest) {
        dest.id = this.id;
        dest.setHasNoCloseTag(this.hasNoCloseTag);
        dest.setPath(this.path);
        dest.setAutoComponentTag(this.autoComponent);
        if (this.markupClassRef != null) {
            dest.setMarkupClass((Class)this.markupClassRef.get());
        }
        if (this.behaviors != null) {
            dest.behaviors = new ArrayList<IBehavior>(this.behaviors.size());
            dest.behaviors.addAll(this.behaviors);
        }
    }

    public final void put(String key, boolean value) {
        this.xmlTag.put(key, value);
        this.setModified(true);
    }

    public final void put(String key, int value) {
        this.xmlTag.put(key, value);
        this.setModified(true);
    }

    public final void put(String key, CharSequence value) {
        this.xmlTag.put(key, value);
        this.setModified(true);
    }

    public final void put(String key, StringValue value) {
        this.xmlTag.put(key, value);
        this.setModified(true);
    }

    public final void putAll(Map<String, Object> map) {
        this.xmlTag.putAll(map);
        this.setModified(true);
    }

    public final void remove(String key) {
        this.xmlTag.remove(key);
        this.setModified(true);
    }

    public final boolean requiresCloseTag() {
        if (this.getNamespace() == null) {
            return HtmlHandler.requiresCloseTag(this.getName());
        }
        return HtmlHandler.requiresCloseTag(this.getNamespace() + ":" + this.getName());
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setName(String name) {
        this.xmlTag.setName(name);
    }

    public final void setNamespace(String namespace) {
        this.xmlTag.setNamespace(namespace);
    }

    public final void setOpenTag(ComponentTag tag) {
        this.closes = tag;
        this.getXmlTag().setOpenTag(tag.getXmlTag());
    }

    public final void setType(XmlTag.Type type) {
        this.xmlTag.setType(type);
    }

    public final CharSequence syntheticCloseTagString() {
        AppendingStringBuffer buf = new AppendingStringBuffer();
        buf.append("</");
        if (this.getNamespace() != null) {
            buf.append(this.getNamespace()).append(":");
        }
        buf.append(this.getName()).append(">");
        return buf;
    }

    @Override
    public CharSequence toCharSequence() {
        return this.xmlTag.toCharSequence();
    }

    public final String toString() {
        return ((Object)this.toCharSequence()).toString();
    }

    public final void writeOutput(Response response, boolean stripWicketAttributes, String namespace) {
        response.write("<");
        if (this.getType() == XmlTag.CLOSE) {
            response.write("/");
        }
        if (this.getNamespace() != null) {
            response.write(this.getNamespace());
            response.write(":");
        }
        response.write(this.getName());
        String namespacePrefix = null;
        if (stripWicketAttributes) {
            namespacePrefix = namespace + ":";
        }
        if (this.getAttributes().size() > 0) {
            for (String key : this.getAttributes().keySet()) {
                if (key == null || namespacePrefix != null && key.startsWith(namespacePrefix)) continue;
                response.write(" ");
                response.write(key);
                CharSequence value = this.getString(key);
                if (value == null) continue;
                response.write("=\"");
                value = Strings.replaceAll(value, "\"", "&#34;");
                response.write(value);
                response.write("\"");
            }
        }
        if (this.getType() == XmlTag.OPEN_CLOSE) {
            response.write("/");
        }
        response.write(">");
    }

    @Override
    public final String toUserDebugString() {
        return this.xmlTag.toUserDebugString();
    }

    final XmlTag getXmlTag() {
        return this.xmlTag;
    }

    public final void setModified(boolean modified) {
        this.modified = modified;
    }

    public final boolean isModified() {
        return this.modified;
    }

    public String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    public boolean hasNoCloseTag() {
        return this.hasNoCloseTag;
    }

    public void setHasNoCloseTag(boolean hasNoCloseTag) {
        this.hasNoCloseTag = hasNoCloseTag;
    }

    public Class<? extends Component> getMarkupClass() {
        return this.markupClassRef == null ? null : (Class)this.markupClassRef.get();
    }

    public <C extends Component> void setMarkupClass(Class<C> wicketHeaderClass) {
        this.markupClassRef = wicketHeaderClass == null ? null : new WeakReference<Class<C>>(wicketHeaderClass);
    }

    @Override
    public boolean equalTo(MarkupElement element) {
        if (element instanceof ComponentTag) {
            ComponentTag that = (ComponentTag)element;
            return this.getXmlTag().equalTo(that.getXmlTag());
        }
        return false;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isAutoComponentTag() {
        return this.autoComponent;
    }

    public void setAutoComponentTag(boolean auto) {
        this.autoComponent = auto;
    }

    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(key, value);
    }

    public void onBeforeRender(Component component, MarkupStream markupStream) {
    }
}

