/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptySrcAttributeCheckFilter
implements IResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(EmptySrcAttributeCheckFilter.class);
    public static final EmptySrcAttributeCheckFilter INSTANCE = new EmptySrcAttributeCheckFilter();

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int pos = responseBuffer.indexOf("src=\"\"");
        if (pos < 0) {
            pos = responseBuffer.indexOf("src=''");
        }
        if (pos >= 0) {
            log.warn("Empty src attribute found in response:");
            int from = Math.max(0, pos - 32);
            int to = Math.min(pos + 32, responseBuffer.length());
            log.warn("[...]" + responseBuffer.substring(from, to) + "[...]");
        }
        return responseBuffer;
    }
}

