/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.body;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BodyTagAttributeModifier
extends AttributeModifier {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Component> componentReference;

    public BodyTagAttributeModifier(String attribute, boolean addAttributeIfNotPresent, IModel<?> replaceModel, Component behaviorOwner) {
        super(attribute, addAttributeIfNotPresent, replaceModel);
        this.init(behaviorOwner);
    }

    public BodyTagAttributeModifier(String attribute, IModel<?> replaceModel, Component behaviorOwner) {
        super(attribute, replaceModel);
        this.init(behaviorOwner);
    }

    public BodyTagAttributeModifier(String attribute, String pattern, boolean addAttributeIfNotPresent, IModel<?> replaceModel, Component behaviorOwner) {
        super(attribute, pattern, addAttributeIfNotPresent, replaceModel);
        this.init(behaviorOwner);
    }

    public BodyTagAttributeModifier(String attribute, String pattern, IModel<?> replaceModel, Component behaviorOwner) {
        super(attribute, pattern, replaceModel);
        this.init(behaviorOwner);
    }

    private void init(Component behaviorOwner) {
        if (behaviorOwner != null) {
            this.componentReference = new WeakReference<Component>(behaviorOwner);
        }
    }

    @Override
    protected String newValue(String currentValue, String replacementValue) {
        if (this.componentReference != null) {
            Component behaviorOwner = (Component)this.componentReference.get();
            if (behaviorOwner == null) {
                this.setEnabled(false);
                return currentValue;
            }
            if (!(behaviorOwner instanceof Page) && behaviorOwner.findParent(Page.class) == null) {
                this.setEnabled(false);
                return currentValue;
            }
            if (!behaviorOwner.isVisibleInHierarchy()) {
                return currentValue;
            }
        }
        if (currentValue != null && !currentValue.trim().endsWith(";")) {
            return currentValue + ";" + replacementValue;
        }
        return currentValue == null ? replacementValue : currentValue + replacementValue;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        Object object = inputStream.readObject();
        if (object != null) {
            this.componentReference = new WeakReference<Component>((Component)object);
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        if (this.componentReference != null) {
            outputStream.writeObject(this.componentReference.get());
        } else {
            outputStream.writeObject(null);
        }
    }
}

