/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckGroup<T>
extends FormComponent<Collection<T>>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public CheckGroup(String id) {
        super(id);
        this.setRenderBodyOnly(true);
    }

    public CheckGroup(String id, Collection<T> collection) {
        this(id, new CollectionModel<T>(collection));
    }

    public CheckGroup(String id, IModel<Collection<T>> model) {
        super(id, model);
        this.setRenderBodyOnly(true);
    }

    @Override
    protected Collection<T> convertValue(String[] values) throws ConversionException {
        ArrayList collection = new ArrayList();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                final String value = values[i];
                if (value == null) continue;
                Check checkbox = (Check)this.visitChildren(Check.class, new Component.IVisitor<Check<T>>(){

                    @Override
                    public Object component(Check<T> check) {
                        if (String.valueOf(check.getValue()).equals(value)) {
                            return check;
                        }
                        return CONTINUE_TRAVERSAL;
                    }
                });
                if (checkbox == null) {
                    throw new WicketRuntimeException("submitted http post value [" + Strings.join(",", values) + "] for CheckGroup component [" + this.getPath() + "] contains an illegal relative path " + "element [" + value + "] which does not point to a Check component. Due to this the CheckGroup component cannot resolve the selected Check component pointed to by the illegal value. A possible reason is that componment hierarchy changed between rendering and form submission.");
                }
                collection.add(checkbox.getModelObject());
            }
        }
        return collection;
    }

    @Override
    public void updateModel() {
        Collection collection = (Collection)this.getModelObject();
        if (collection == null) {
            collection = (Collection)this.getConvertedInput();
            this.setDefaultModelObject(collection);
        } else {
            this.modelChanging();
            collection.clear();
            collection.addAll((Collection)this.getConvertedInput());
            this.modelChanged();
        }
    }

    @Override
    protected final boolean supportsPersistence() {
        return false;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("disabled");
        tag.remove("name");
    }

    @Override
    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged((Collection)this.getModelObject());
    }

    protected void onSelectionChanged(Collection<? extends T> newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }
}

