/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.DynamicWebResource;
import org.apache.wicket.util.time.Time;

public abstract class DynamicImageResource
extends DynamicWebResource {
    private static final long serialVersionUID = 1L;
    private String format = "png";
    private Time lastModifiedTime;

    public DynamicImageResource() {
    }

    public DynamicImageResource(Locale locale) {
        super(locale);
    }

    public DynamicImageResource(String format) {
        this.setFormat(format);
    }

    public DynamicImageResource(String format, Locale locale) {
        super(locale);
        this.setFormat(format);
    }

    public final synchronized String getFormat() {
        return this.format;
    }

    public final synchronized void setFormat(String format) {
        this.format = format;
    }

    protected synchronized void setLastModifiedTime(Time time) {
        this.lastModifiedTime = time;
    }

    protected byte[] toImageData(BufferedImage image) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, this.format, out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to convert dynamic image to stream", e);
        }
    }

    protected synchronized DynamicWebResource.ResourceState getResourceState() {
        return new DynamicWebResource.ResourceState(){
            private byte[] imageData;
            private final String contentType;
            {
                this.contentType = "image/" + DynamicImageResource.this.format;
            }

            public Time lastModifiedTime() {
                if (this.lastModifiedTime == null) {
                    this.lastModifiedTime = DynamicImageResource.this.lastModifiedTime;
                    if (this.lastModifiedTime == null) {
                        this.lastModifiedTime = Time.now();
                    }
                }
                return this.lastModifiedTime;
            }

            public byte[] getData() {
                if (this.imageData == null) {
                    this.imageData = DynamicImageResource.this.getImageData();
                }
                return this.imageData;
            }

            public String getContentType() {
                return this.contentType;
            }
        };
    }

    protected abstract byte[] getImageData();
}

