/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.TagAttributes;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadForceTagIdHandler
extends AbstractMarkupFilter {
    private final String headElementIdPrefix;
    private int counter = 0;
    private boolean inHead = false;

    public HeadForceTagIdHandler(Class<?> markupFileClass) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(markupFileClass.getName());
        for (int i = 0; i < buffer.getValue().length; ++i) {
            if (Character.isLetterOrDigit(buffer.getValue()[i])) continue;
            buffer.getValue()[i] = 45;
        }
        buffer.append("-");
        this.headElementIdPrefix = buffer.toString();
    }

    @Override
    public MarkupElement nextTag() throws ParseException {
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag != null) {
            if (tag instanceof WicketTag && ((WicketTag)tag).isHeadTag()) {
                this.inHead = tag.isOpen();
            } else if (this.inHead && !(tag instanceof WicketTag) && tag.getId() == null && (tag.isOpen() || tag.isOpenClose()) && this.needId(tag) && tag.getAttributes().get("id") == null) {
                ((TagAttributes)tag.getAttributes()).putInternal("id", this.headElementIdPrefix + this.nextValue());
                tag.setModified(true);
            }
        }
        return tag;
    }

    private final boolean needId(ComponentTag tag) {
        String name = tag.getName().toLowerCase();
        if (name.equals("script") && !tag.getAttributes().containsKey("src")) {
            return true;
        }
        return name.equals("style") && !tag.getAttributes().containsKey("href");
    }

    private final int nextValue() {
        return this.counter++;
    }
}

