/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.collections.IntHashMap;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageStore
implements SecondLevelCacheSessionStore.IPageStore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SerializedPage> serializePage(Page page) {
        final ArrayList<SerializedPage> result = new ArrayList<SerializedPage>();
        SerializedPage initialPage = new SerializedPage(page);
        result.add(initialPage);
        PageSerializer serializer = new PageSerializer(initialPage){

            protected void onPageSerialized(SerializedPage page) {
                result.add(page);
            }
        };
        Page.serializer.set(serializer);
        try {
            initialPage.setData(Objects.objectToByteArray(page.getPageMapEntry()));
        }
        finally {
            Page.serializer.set(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page deserializePage(byte[] data, int versionNumber) {
        boolean set = Page.serializer.get() == null;
        Page page = null;
        try {
            IPageMapEntry entry;
            if (set) {
                Page.serializer.set(new PageSerializer(null));
            }
            if ((entry = (IPageMapEntry)Objects.byteArrayToObject(data)) != null) {
                page = entry.getPage();
                if (versionNumber != -1) {
                    page = page.getVersion(versionNumber);
                }
            }
        }
        finally {
            if (set) {
                Page.serializer.set(null);
            }
        }
        return page;
    }

    private static class PageHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int pageid;
        private final String pagemap;

        PageHolder(Page page) {
            this.pageid = page.getNumericId();
            this.pagemap = page.getPageMapName();
        }

        protected Object readResolve() throws ObjectStreamException {
            return Session.get().getPage(this.pagemap, Integer.toString(this.pageid), -1);
        }
    }

    private static class PageSerializer
    implements Page.IPageSerializer {
        private SerializedPage current;
        private final List<SerializedPage> completed = new ArrayList<SerializedPage>();

        public Object getPageReplacementObject(Page callingPage) {
            SerializedPage calling = new SerializedPage(callingPage);
            if (calling.equals(this.current)) {
                this.completed.add(calling);
                return callingPage;
            }
            if (!this.completed.contains(calling)) {
                SerializedPage prev = this.current;
                this.current = calling;
                SerializedPage.access$002(this.current, Objects.objectToByteArray(callingPage));
                this.onPageSerialized(this.current);
                this.current = prev;
            }
            return new PageHolder(callingPage);
        }

        protected void onPageSerialized(SerializedPage page) {
        }

        public PageSerializer(SerializedPage page) {
            this.current = page;
        }

        public void serializePage(Page page, ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        public void deserializePage(int id, String pageMapName, Page page, ObjectInputStream stream) throws IOException, ClassNotFoundException {
            IntHashMap<Page> pages = SecondLevelCacheSessionStore.getUsedPages(pageMapName);
            pages.put(id, page);
            stream.defaultReadObject();
        }
    }

    protected static class SerializedPage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int pageId;
        private final String pageMapName;
        private final int versionNumber;
        private final int ajaxVersionNumber;
        private byte[] data;

        public SerializedPage(int pageId, String pageMapName, int versionNumber, int ajaxVersionNumber, byte[] data) {
            this.pageId = pageId;
            this.pageMapName = pageMapName;
            this.versionNumber = versionNumber;
            this.ajaxVersionNumber = ajaxVersionNumber;
            this.data = data;
        }

        public SerializedPage(Page page) {
            this.pageId = page.getNumericId();
            this.pageMapName = page.getPageMapName();
            this.versionNumber = page.getCurrentVersionNumber();
            this.ajaxVersionNumber = page.getAjaxVersionNumber();
        }

        public int getPageId() {
            return this.pageId;
        }

        public String getPageMapName() {
            return this.pageMapName;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }

        public int getAjaxVersionNumber() {
            return this.ajaxVersionNumber;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public int hashCode() {
            return this.pageId * 1931 + this.versionNumber * 13 + this.ajaxVersionNumber * 301 + (this.pageMapName != null ? this.pageMapName.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SerializedPage)) {
                return false;
            }
            SerializedPage rhs = (SerializedPage)obj;
            return this.pageId == rhs.pageId && (this.pageMapName == rhs.pageMapName || this.pageMapName != null && this.pageMapName.equals(rhs.pageMapName)) && this.versionNumber == rhs.versionNumber && this.ajaxVersionNumber == rhs.ajaxVersionNumber;
        }

        static /* synthetic */ byte[] access$002(SerializedPage x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }
}

