/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSynchronousFilePageStore
extends AbstractPageStore {
    private final File defaultWorkDir;
    private final String appName;
    private static final Logger log = LoggerFactory.getLogger(SimpleSynchronousFilePageStore.class);

    public SimpleSynchronousFilePageStore(File workDir) {
        this.defaultWorkDir = workDir;
        this.defaultWorkDir.mkdirs();
        this.appName = Application.get().getApplicationKey();
    }

    public SimpleSynchronousFilePageStore() {
        this((File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir"));
    }

    private String getFileName(String pageMapName, int pageId) {
        return this.appName + "-pm-" + pageMapName + "-p-" + pageId;
    }

    private void sortFiles(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                File f1 = arg0;
                File f2 = arg1;
                return f1.lastModified() < f2.lastModified() ? -1 : (f1.lastModified() == f2.lastModified() ? 0 : 1);
            }
        });
    }

    private File getPageFile(File sessionDir, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        final String fileNamePrefix = this.getFileName(pageMapName, pageId);
        if (versionNumber != -1 && ajaxVersionNumber != -1) {
            return new File(sessionDir, fileNamePrefix + "-v-" + versionNumber + "-a-" + ajaxVersionNumber);
        }
        if (versionNumber == -1) {
            File[] files = sessionDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(fileNamePrefix);
                }
            });
            if (files == null || files.length == 0) {
                return null;
            }
            this.sortFiles(files);
            return files[files.length - 1];
        }
        final String prefixWithVersion = fileNamePrefix + "-v-" + versionNumber;
        File[] files = sessionDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefixWithVersion);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        int lastAjaxVersion = -1;
        int indexWithBiggestAjaxVersion = -1;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String ajaxVersionString = file.getName().substring(file.getName().lastIndexOf(45) + 1);
            int ajaxVersion = Integer.parseInt(ajaxVersionString);
            if (lastAjaxVersion >= ajaxVersion) continue;
            lastAjaxVersion = ajaxVersion;
            indexWithBiggestAjaxVersion = i;
        }
        return files[indexWithBiggestAjaxVersion];
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadPageData(File workDir, String sessionId, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        File pageFile;
        File sessionDir = new File(workDir, sessionId);
        byte[] pageData = null;
        if (sessionDir.exists() && (pageFile = this.getPageFile(sessionDir, pageMapName, pageId, versionNumber, ajaxVersionNumber)).exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(pageFile);
                int length = (int)pageFile.length();
                ByteBuffer bb = ByteBuffer.allocate(length);
                fis.getChannel().read(bb);
                if (bb.hasArray()) {
                    pageData = bb.array();
                } else {
                    pageData = new byte[length];
                    bb.get(pageData);
                }
            }
            catch (Exception e) {
                log.debug("Error loading page " + pageId + "," + versionNumber + " for the sessionid " + sessionId + " from disk", (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return pageData;
    }

    public Page getPage(String sessionId, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        byte[] data = this.loadPageData(this.defaultWorkDir, sessionId, pageMapName, pageId, versionNumber, ajaxVersionNumber);
        if (data != null) {
            return this.deserializePage(data, versionNumber);
        }
        return null;
    }

    public void pageAccessed(String sessionId, Page page) {
    }

    private void removeFiles(String sessionId, String pageMap, int id) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        if (sessionDir.exists()) {
            final String filepart = id != -1 ? this.appName + "-pm-" + pageMap + "-p-" + id : this.appName + "-pm-" + pageMap;
            File[] listFiles = sessionDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(filepart);
                }
            });
            for (int i = 0; i < listFiles.length; ++i) {
                listFiles[i].delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long savePageData(String sessionId, AbstractPageStore.SerializedPage page) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        sessionDir.mkdirs();
        File pageFile = this.getPageFile(sessionDir, page.getPageMapName(), page.getPageId(), page.getVersionNumber(), page.getAjaxVersionNumber());
        FileOutputStream fos = null;
        int length = 0;
        try {
            fos = new FileOutputStream(pageFile);
            ByteBuffer bb = ByteBuffer.wrap(page.getData());
            fos.getChannel().write(bb);
            length = page.getData().length;
        }
        catch (Exception e) {
            log.error("Error saving page " + pageFile.getAbsolutePath());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {}
        }
        return length;
    }

    public void removePage(String sessionId, String pageMapName, int pageId) {
        this.removeFiles(sessionId, pageMapName, pageId);
    }

    public void storePage(String sessionId, Page page) {
        List<AbstractPageStore.SerializedPage> serialized = this.serializePage(page);
        for (AbstractPageStore.SerializedPage serializedPage : serialized) {
            this.savePageData(sessionId, serializedPage);
        }
    }

    private void removeSession(String sessionId) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        if (sessionDir.exists()) {
            File[] files = sessionDir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            if (!sessionDir.delete()) {
                sessionDir.deleteOnExit();
            }
        }
    }

    public void unbind(String sessionId) {
        this.removeSession(sessionId);
    }

    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        File pageFile = this.getPageFile(sessionDir, pageMapName, pageId, pageVersion, -1);
        return pageFile.exists();
    }
}

