/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletPortletSessionProxy
implements InvocationHandler {
    HttpSession servletSession;
    String portletWindowPrefix;

    public static HttpSession createProxy(HttpServletRequest request, String portletWindowId) {
        String portletWindowNamespace = "javax.portlet.p." + portletWindowId;
        HttpSession servletSession = request.getSession();
        HashSet interfaces = new HashSet();
        interfaces.add(HttpSession.class);
        Class<?> current = servletSession.getClass();
        while (current != null) {
            try {
                Class<?>[] currentInterfaces = current.getInterfaces();
                for (int i = 0; i < currentInterfaces.length; ++i) {
                    interfaces.add(currentInterfaces[i]);
                }
                current = current.getSuperclass();
            }
            catch (Exception e) {
                current = null;
            }
        }
        Object proxy = Proxy.newProxyInstance(servletSession.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new ServletPortletSessionProxy(request.getSession(), portletWindowNamespace));
        return (HttpSession)proxy;
    }

    private ServletPortletSessionProxy(HttpSession servletSession, String portletWindowPrefix) {
        this.servletSession = servletSession;
        this.portletWindowPrefix = portletWindowPrefix;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String[] retval = null;
        if (("getAttribute".equals(m.getName()) || "getValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            retval = this.servletSession.getAttribute(this.portletWindowPrefix + (String)args[0]);
        } else if (("setAttribute".equals(m.getName()) || "putValue".equals(m.getName())) && args.length == 2 && args[0] instanceof String) {
            this.servletSession.setAttribute(this.portletWindowPrefix + (String)args[0], args[1]);
        } else if (("removeAttribute".equals(m.getName()) || "removeValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            this.servletSession.removeAttribute(this.portletWindowPrefix + (String)args[0]);
        } else if ("getAttributeNames".equals(m.getName()) && args == null) {
            retval = new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletWindowPrefix);
        } else if ("getValueNames".equals(m.getName()) && args == null) {
            ArrayList list = new ArrayList();
            NamespacedNamesEnumeration e = new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletWindowPrefix);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            retval = list.toArray(new String[list.size()]);
        } else {
            retval = m.invoke((Object)this.servletSession, args);
        }
        return retval;
    }

    private static class NamespacedNamesEnumeration
    implements Enumeration {
        private final Enumeration namesEnumeration;
        private final String namespace;
        private String nextName;
        private boolean done;

        public NamespacedNamesEnumeration(Enumeration namesEnumeration, String namespace) {
            this.namesEnumeration = namesEnumeration;
            this.namespace = namespace;
            this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            if (!this.done && this.nextName == null) {
                while (this.namesEnumeration.hasMoreElements()) {
                    String name = (String)this.namesEnumeration.nextElement();
                    if (!name.startsWith(this.namespace)) continue;
                    this.nextName = name.substring(this.namespace.length());
                    break;
                }
                this.done = this.nextName == null;
            }
            return !this.done;
        }

        public Object nextElement() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            String name = this.nextName;
            this.nextName = null;
            return name;
        }
    }
}

